/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.session.attribute.object.session.attribute.object;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.Priority;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TunnelAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.session.attribute.object.session.attribute.object.BasicSessionAttributeObject;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class BasicSessionAttributeObjectBuilder
implements Builder<BasicSessionAttributeObject> {
    private AttributeFilter _excludeAny;
    private Short _holdPriority;
    private AttributeFilter _includeAll;
    private AttributeFilter _includeAny;
    private String _sessionName;
    private Short _setupPriority;
    private Boolean _labelRecordingDesired;
    private Boolean _localProtectionDesired;
    private Boolean _seStyleDesired;
    Map<Class<? extends Augmentation<BasicSessionAttributeObject>>, Augmentation<BasicSessionAttributeObject>> augmentation = Collections.emptyMap();

    public BasicSessionAttributeObjectBuilder() {
    }

    public BasicSessionAttributeObjectBuilder(TunnelAttributes arg) {
        this._localProtectionDesired = arg.isLocalProtectionDesired();
        this._labelRecordingDesired = arg.isLabelRecordingDesired();
        this._seStyleDesired = arg.isSeStyleDesired();
        this._sessionName = arg.getSessionName();
        this._holdPriority = arg.getHoldPriority();
        this._setupPriority = arg.getSetupPriority();
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }

    public BasicSessionAttributeObjectBuilder(Priority arg) {
        this._holdPriority = arg.getHoldPriority();
        this._setupPriority = arg.getSetupPriority();
    }

    public BasicSessionAttributeObjectBuilder(AttributeFilters arg) {
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }

    public BasicSessionAttributeObjectBuilder(BasicSessionAttributeObject base) {
        AugmentationHolder casted;
        this._excludeAny = base.getExcludeAny();
        this._holdPriority = base.getHoldPriority();
        this._includeAll = base.getIncludeAll();
        this._includeAny = base.getIncludeAny();
        this._sessionName = base.getSessionName();
        this._setupPriority = base.getSetupPriority();
        this._labelRecordingDesired = base.isLabelRecordingDesired();
        this._localProtectionDesired = base.isLocalProtectionDesired();
        this._seStyleDesired = base.isSeStyleDesired();
        if (base instanceof BasicSessionAttributeObjectImpl) {
            BasicSessionAttributeObjectImpl impl = (BasicSessionAttributeObjectImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<BasicSessionAttributeObject>>, Augmentation<BasicSessionAttributeObject>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<BasicSessionAttributeObject>>, Augmentation<BasicSessionAttributeObject>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Priority) {
            this._holdPriority = ((Priority)arg).getHoldPriority();
            this._setupPriority = ((Priority)arg).getSetupPriority();
            isValidArg = true;
        }
        if (arg instanceof AttributeFilters) {
            this._includeAny = ((AttributeFilters)arg).getIncludeAny();
            this._excludeAny = ((AttributeFilters)arg).getExcludeAny();
            this._includeAll = ((AttributeFilters)arg).getIncludeAll();
            isValidArg = true;
        }
        if (arg instanceof TunnelAttributes) {
            this._localProtectionDesired = ((TunnelAttributes)arg).isLocalProtectionDesired();
            this._labelRecordingDesired = ((TunnelAttributes)arg).isLabelRecordingDesired();
            this._seStyleDesired = ((TunnelAttributes)arg).isSeStyleDesired();
            this._sessionName = ((TunnelAttributes)arg).getSessionName();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.Priority, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilters, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TunnelAttributes]");
    }

    public AttributeFilter getExcludeAny() {
        return this._excludeAny;
    }

    public Short getHoldPriority() {
        return this._holdPriority;
    }

    public AttributeFilter getIncludeAll() {
        return this._includeAll;
    }

    public AttributeFilter getIncludeAny() {
        return this._includeAny;
    }

    public String getSessionName() {
        return this._sessionName;
    }

    public Short getSetupPriority() {
        return this._setupPriority;
    }

    public Boolean isLabelRecordingDesired() {
        return this._labelRecordingDesired;
    }

    public Boolean isLocalProtectionDesired() {
        return this._localProtectionDesired;
    }

    public Boolean isSeStyleDesired() {
        return this._seStyleDesired;
    }

    public <E extends Augmentation<BasicSessionAttributeObject>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public BasicSessionAttributeObjectBuilder setExcludeAny(AttributeFilter value) {
        this._excludeAny = value;
        return this;
    }

    private static void checkHoldPriorityRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..255]]", (Object)value);
    }

    public BasicSessionAttributeObjectBuilder setHoldPriority(Short value) {
        if (value != null) {
            BasicSessionAttributeObjectBuilder.checkHoldPriorityRange(value);
        }
        this._holdPriority = value;
        return this;
    }

    public BasicSessionAttributeObjectBuilder setIncludeAll(AttributeFilter value) {
        this._includeAll = value;
        return this;
    }

    public BasicSessionAttributeObjectBuilder setIncludeAny(AttributeFilter value) {
        this._includeAny = value;
        return this;
    }

    public BasicSessionAttributeObjectBuilder setSessionName(String value) {
        this._sessionName = value;
        return this;
    }

    private static void checkSetupPriorityRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..255]]", (Object)value);
    }

    public BasicSessionAttributeObjectBuilder setSetupPriority(Short value) {
        if (value != null) {
            BasicSessionAttributeObjectBuilder.checkSetupPriorityRange(value);
        }
        this._setupPriority = value;
        return this;
    }

    public BasicSessionAttributeObjectBuilder setLabelRecordingDesired(Boolean value) {
        this._labelRecordingDesired = value;
        return this;
    }

    public BasicSessionAttributeObjectBuilder setLocalProtectionDesired(Boolean value) {
        this._localProtectionDesired = value;
        return this;
    }

    public BasicSessionAttributeObjectBuilder setSeStyleDesired(Boolean value) {
        this._seStyleDesired = value;
        return this;
    }

    public BasicSessionAttributeObjectBuilder addAugmentation(Class<? extends Augmentation<BasicSessionAttributeObject>> augmentationType, Augmentation<BasicSessionAttributeObject> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<BasicSessionAttributeObject>>, Augmentation<BasicSessionAttributeObject>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public BasicSessionAttributeObjectBuilder removeAugmentation(Class<? extends Augmentation<BasicSessionAttributeObject>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public BasicSessionAttributeObject build() {
        return new BasicSessionAttributeObjectImpl(this);
    }

    private static final class BasicSessionAttributeObjectImpl
    implements BasicSessionAttributeObject {
        private final AttributeFilter _excludeAny;
        private final Short _holdPriority;
        private final AttributeFilter _includeAll;
        private final AttributeFilter _includeAny;
        private final String _sessionName;
        private final Short _setupPriority;
        private final Boolean _labelRecordingDesired;
        private final Boolean _localProtectionDesired;
        private final Boolean _seStyleDesired;
        private Map<Class<? extends Augmentation<BasicSessionAttributeObject>>, Augmentation<BasicSessionAttributeObject>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        private BasicSessionAttributeObjectImpl(BasicSessionAttributeObjectBuilder base) {
            this._excludeAny = base.getExcludeAny();
            this._holdPriority = base.getHoldPriority();
            this._includeAll = base.getIncludeAll();
            this._includeAny = base.getIncludeAny();
            this._sessionName = base.getSessionName();
            this._setupPriority = base.getSetupPriority();
            this._labelRecordingDesired = base.isLabelRecordingDesired();
            this._localProtectionDesired = base.isLocalProtectionDesired();
            this._seStyleDesired = base.isSeStyleDesired();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<BasicSessionAttributeObject> getImplementedInterface() {
            return BasicSessionAttributeObject.class;
        }

        @Override
        public AttributeFilter getExcludeAny() {
            return this._excludeAny;
        }

        @Override
        public Short getHoldPriority() {
            return this._holdPriority;
        }

        @Override
        public AttributeFilter getIncludeAll() {
            return this._includeAll;
        }

        @Override
        public AttributeFilter getIncludeAny() {
            return this._includeAny;
        }

        @Override
        public String getSessionName() {
            return this._sessionName;
        }

        @Override
        public Short getSetupPriority() {
            return this._setupPriority;
        }

        @Override
        public Boolean isLabelRecordingDesired() {
            return this._labelRecordingDesired;
        }

        @Override
        public Boolean isLocalProtectionDesired() {
            return this._localProtectionDesired;
        }

        @Override
        public Boolean isSeStyleDesired() {
            return this._seStyleDesired;
        }

        public <E extends Augmentation<BasicSessionAttributeObject>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._excludeAny);
            result = 31 * result + Objects.hashCode(this._holdPriority);
            result = 31 * result + Objects.hashCode(this._includeAll);
            result = 31 * result + Objects.hashCode(this._includeAny);
            result = 31 * result + Objects.hashCode(this._sessionName);
            result = 31 * result + Objects.hashCode(this._setupPriority);
            result = 31 * result + Objects.hashCode(this._labelRecordingDesired);
            result = 31 * result + Objects.hashCode(this._localProtectionDesired);
            result = 31 * result + Objects.hashCode(this._seStyleDesired);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!BasicSessionAttributeObject.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            BasicSessionAttributeObject other = (BasicSessionAttributeObject)obj;
            if (!Objects.equals(this._excludeAny, other.getExcludeAny())) {
                return false;
            }
            if (!Objects.equals(this._holdPriority, other.getHoldPriority())) {
                return false;
            }
            if (!Objects.equals(this._includeAll, other.getIncludeAll())) {
                return false;
            }
            if (!Objects.equals(this._includeAny, other.getIncludeAny())) {
                return false;
            }
            if (!Objects.equals(this._sessionName, other.getSessionName())) {
                return false;
            }
            if (!Objects.equals(this._setupPriority, other.getSetupPriority())) {
                return false;
            }
            if (!Objects.equals(this._labelRecordingDesired, other.isLabelRecordingDesired())) {
                return false;
            }
            if (!Objects.equals(this._localProtectionDesired, other.isLocalProtectionDesired())) {
                return false;
            }
            if (!Objects.equals(this._seStyleDesired, other.isSeStyleDesired())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                BasicSessionAttributeObjectImpl otherImpl = (BasicSessionAttributeObjectImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<BasicSessionAttributeObject>>, Augmentation<BasicSessionAttributeObject>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"BasicSessionAttributeObject");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_excludeAny", (Object)this._excludeAny);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_holdPriority", (Object)this._holdPriority);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_includeAll", (Object)this._includeAll);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_includeAny", (Object)this._includeAny);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_sessionName", (Object)this._sessionName);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_setupPriority", (Object)this._setupPriority);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_labelRecordingDesired", (Object)this._labelRecordingDesired);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_localProtectionDesired", (Object)this._localProtectionDesired);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_seStyleDesired", (Object)this._seStyleDesired);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

