/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.binding.Enumeration;

public enum LinkFlags implements Enumeration
{
    TotallyUnprotected(0, "totally-unprotected"),
    ExtraTraffic(1, "extra-traffic"),
    Unprotected(2, "unprotected"),
    Shared(4, "shared"),
    Dedicated1to1(8, "dedicated-1to1"),
    Dedicated1plus1(10, "dedicated-1plus1"),
    Enhanced(20, "enhanced");

    private static final Map<String, LinkFlags> NAME_MAP;
    private static final Map<Integer, LinkFlags> VALUE_MAP;
    private final String name;
    private final int value;

    private LinkFlags(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getIntValue() {
        return this.value;
    }

    public static Optional<LinkFlags> forName(String name) {
        return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
    }

    public static LinkFlags forValue(int intValue) {
        return VALUE_MAP.get(intValue);
    }

    static {
        ImmutableMap.Builder nb = ImmutableMap.builder();
        ImmutableMap.Builder vb = ImmutableMap.builder();
        for (LinkFlags enumItem : LinkFlags.values()) {
            vb.put((Object)enumItem.value, (Object)enumItem);
            nb.put((Object)enumItem.name, (Object)enumItem);
        }
        NAME_MAP = nb.build();
        VALUE_MAP = vb.build();
    }
}

