/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.protection.subobject;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.LinkFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.LspFlag;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.protection.subobject.ProtectionSubobject;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ProtectionSubobjectBuilder
implements Builder<ProtectionSubobject> {
    private LinkFlags _linkFlags;
    private LspFlag _lspFlag;
    private LspFlag _segFlag;
    private Boolean _inPlace;
    private Boolean _notification;
    private Boolean _operational;
    private Boolean _protecting;
    private Boolean _required;
    private Boolean _secondary;
    Map<Class<? extends Augmentation<ProtectionSubobject>>, Augmentation<ProtectionSubobject>> augmentation = Collections.emptyMap();

    public ProtectionSubobjectBuilder() {
    }

    public ProtectionSubobjectBuilder(ProtectionSubobject base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ProtectionSubobject>>, Augmentation<ProtectionSubobject>>(aug);
        }
        this._linkFlags = base.getLinkFlags();
        this._lspFlag = base.getLspFlag();
        this._segFlag = base.getSegFlag();
        this._inPlace = base.isInPlace();
        this._notification = base.isNotification();
        this._operational = base.isOperational();
        this._protecting = base.isProtecting();
        this._required = base.isRequired();
        this._secondary = base.isSecondary();
    }

    public LinkFlags getLinkFlags() {
        return this._linkFlags;
    }

    public LspFlag getLspFlag() {
        return this._lspFlag;
    }

    public LspFlag getSegFlag() {
        return this._segFlag;
    }

    public Boolean isInPlace() {
        return this._inPlace;
    }

    public Boolean isNotification() {
        return this._notification;
    }

    public Boolean isOperational() {
        return this._operational;
    }

    public Boolean isProtecting() {
        return this._protecting;
    }

    public Boolean isRequired() {
        return this._required;
    }

    public Boolean isSecondary() {
        return this._secondary;
    }

    public <E$$ extends Augmentation<ProtectionSubobject>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public ProtectionSubobjectBuilder setLinkFlags(LinkFlags value) {
        this._linkFlags = value;
        return this;
    }

    public ProtectionSubobjectBuilder setLspFlag(LspFlag value) {
        this._lspFlag = value;
        return this;
    }

    public ProtectionSubobjectBuilder setSegFlag(LspFlag value) {
        this._segFlag = value;
        return this;
    }

    public ProtectionSubobjectBuilder setInPlace(Boolean value) {
        this._inPlace = value;
        return this;
    }

    public ProtectionSubobjectBuilder setNotification(Boolean value) {
        this._notification = value;
        return this;
    }

    public ProtectionSubobjectBuilder setOperational(Boolean value) {
        this._operational = value;
        return this;
    }

    public ProtectionSubobjectBuilder setProtecting(Boolean value) {
        this._protecting = value;
        return this;
    }

    public ProtectionSubobjectBuilder setRequired(Boolean value) {
        this._required = value;
        return this;
    }

    public ProtectionSubobjectBuilder setSecondary(Boolean value) {
        this._secondary = value;
        return this;
    }

    public ProtectionSubobjectBuilder addAugmentation(Class<? extends Augmentation<ProtectionSubobject>> augmentationType, Augmentation<ProtectionSubobject> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ProtectionSubobject>>, Augmentation<ProtectionSubobject>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ProtectionSubobjectBuilder removeAugmentation(Class<? extends Augmentation<ProtectionSubobject>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ProtectionSubobject build() {
        return new ProtectionSubobjectImpl(this);
    }

    private static final class ProtectionSubobjectImpl
    extends AbstractAugmentable<ProtectionSubobject>
    implements ProtectionSubobject {
        private final LinkFlags _linkFlags;
        private final LspFlag _lspFlag;
        private final LspFlag _segFlag;
        private final Boolean _inPlace;
        private final Boolean _notification;
        private final Boolean _operational;
        private final Boolean _protecting;
        private final Boolean _required;
        private final Boolean _secondary;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ProtectionSubobjectImpl(ProtectionSubobjectBuilder base) {
            super(base.augmentation);
            this._linkFlags = base.getLinkFlags();
            this._lspFlag = base.getLspFlag();
            this._segFlag = base.getSegFlag();
            this._inPlace = base.isInPlace();
            this._notification = base.isNotification();
            this._operational = base.isOperational();
            this._protecting = base.isProtecting();
            this._required = base.isRequired();
            this._secondary = base.isSecondary();
        }

        @Override
        public LinkFlags getLinkFlags() {
            return this._linkFlags;
        }

        @Override
        public LspFlag getLspFlag() {
            return this._lspFlag;
        }

        @Override
        public LspFlag getSegFlag() {
            return this._segFlag;
        }

        @Override
        public Boolean isInPlace() {
            return this._inPlace;
        }

        @Override
        public Boolean isNotification() {
            return this._notification;
        }

        @Override
        public Boolean isOperational() {
            return this._operational;
        }

        @Override
        public Boolean isProtecting() {
            return this._protecting;
        }

        @Override
        public Boolean isRequired() {
            return this._required;
        }

        @Override
        public Boolean isSecondary() {
            return this._secondary;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode((Object)this._linkFlags);
            result = 31 * result + Objects.hashCode((Object)this._lspFlag);
            result = 31 * result + Objects.hashCode((Object)this._segFlag);
            result = 31 * result + Objects.hashCode(this._inPlace);
            result = 31 * result + Objects.hashCode(this._notification);
            result = 31 * result + Objects.hashCode(this._operational);
            result = 31 * result + Objects.hashCode(this._protecting);
            result = 31 * result + Objects.hashCode(this._required);
            result = 31 * result + Objects.hashCode(this._secondary);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ProtectionSubobject.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            ProtectionSubobject other = (ProtectionSubobject)obj;
            if (!Objects.equals((Object)this._linkFlags, (Object)other.getLinkFlags())) {
                return false;
            }
            if (!Objects.equals((Object)this._lspFlag, (Object)other.getLspFlag())) {
                return false;
            }
            if (!Objects.equals((Object)this._segFlag, (Object)other.getSegFlag())) {
                return false;
            }
            if (!Objects.equals(this._inPlace, other.isInPlace())) {
                return false;
            }
            if (!Objects.equals(this._notification, other.isNotification())) {
                return false;
            }
            if (!Objects.equals(this._operational, other.isOperational())) {
                return false;
            }
            if (!Objects.equals(this._protecting, other.isProtecting())) {
                return false;
            }
            if (!Objects.equals(this._required, other.isRequired())) {
                return false;
            }
            if (!Objects.equals(this._secondary, other.isSecondary())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ProtectionSubobjectImpl otherImpl = (ProtectionSubobjectImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"ProtectionSubobject");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_linkFlags", (Object)((Object)this._linkFlags));
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_lspFlag", (Object)((Object)this._lspFlag));
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_segFlag", (Object)((Object)this._segFlag));
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_inPlace", (Object)this._inPlace);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_notification", (Object)this._notification);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_operational", (Object)this._operational);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_protecting", (Object)this._protecting);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_required", (Object)this._required);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_secondary", (Object)this._secondary);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

