/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.tspec.object;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ieee754.rev130819.Float32;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.RsvpTeObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.tspec.object.TspecObject;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;

public class TspecObjectBuilder
implements Builder<TspecObject> {
    private Uint32 _maximumPacketSize;
    private Uint32 _minimumPolicedUnit;
    private Float32 _peakDataRate;
    private Float32 _tokenBucketRate;
    private Float32 _tokenBucketSize;
    Map<Class<? extends Augmentation<TspecObject>>, Augmentation<TspecObject>> augmentation = Collections.emptyMap();

    public TspecObjectBuilder() {
    }

    public TspecObjectBuilder(RsvpTeObject arg) {
    }

    public TspecObjectBuilder(TspecObject base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TspecObject>>, Augmentation<TspecObject>>(aug);
        }
        this._maximumPacketSize = base.getMaximumPacketSize();
        this._minimumPolicedUnit = base.getMinimumPolicedUnit();
        this._peakDataRate = base.getPeakDataRate();
        this._tokenBucketRate = base.getTokenBucketRate();
        this._tokenBucketSize = base.getTokenBucketSize();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof RsvpTeObject) {
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.RsvpTeObject]");
    }

    public Uint32 getMaximumPacketSize() {
        return this._maximumPacketSize;
    }

    public Uint32 getMinimumPolicedUnit() {
        return this._minimumPolicedUnit;
    }

    public Float32 getPeakDataRate() {
        return this._peakDataRate;
    }

    public Float32 getTokenBucketRate() {
        return this._tokenBucketRate;
    }

    public Float32 getTokenBucketSize() {
        return this._tokenBucketSize;
    }

    public <E$$ extends Augmentation<TspecObject>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public TspecObjectBuilder setMaximumPacketSize(Uint32 value) {
        this._maximumPacketSize = value;
        return this;
    }

    @Deprecated(forRemoval=true)
    public TspecObjectBuilder setMaximumPacketSize(Long value) {
        return this.setMaximumPacketSize(CodeHelpers.compatUint((Long)value));
    }

    public TspecObjectBuilder setMinimumPolicedUnit(Uint32 value) {
        this._minimumPolicedUnit = value;
        return this;
    }

    @Deprecated(forRemoval=true)
    public TspecObjectBuilder setMinimumPolicedUnit(Long value) {
        return this.setMinimumPolicedUnit(CodeHelpers.compatUint((Long)value));
    }

    public TspecObjectBuilder setPeakDataRate(Float32 value) {
        this._peakDataRate = value;
        return this;
    }

    public TspecObjectBuilder setTokenBucketRate(Float32 value) {
        this._tokenBucketRate = value;
        return this;
    }

    public TspecObjectBuilder setTokenBucketSize(Float32 value) {
        this._tokenBucketSize = value;
        return this;
    }

    public TspecObjectBuilder addAugmentation(Class<? extends Augmentation<TspecObject>> augmentationType, Augmentation<TspecObject> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TspecObject>>, Augmentation<TspecObject>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public TspecObjectBuilder removeAugmentation(Class<? extends Augmentation<TspecObject>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public TspecObject build() {
        return new TspecObjectImpl(this);
    }

    private static final class TspecObjectImpl
    extends AbstractAugmentable<TspecObject>
    implements TspecObject {
        private final Uint32 _maximumPacketSize;
        private final Uint32 _minimumPolicedUnit;
        private final Float32 _peakDataRate;
        private final Float32 _tokenBucketRate;
        private final Float32 _tokenBucketSize;
        private int hash = 0;
        private volatile boolean hashValid = false;

        TspecObjectImpl(TspecObjectBuilder base) {
            super(base.augmentation);
            this._maximumPacketSize = base.getMaximumPacketSize();
            this._minimumPolicedUnit = base.getMinimumPolicedUnit();
            this._peakDataRate = base.getPeakDataRate();
            this._tokenBucketRate = base.getTokenBucketRate();
            this._tokenBucketSize = base.getTokenBucketSize();
        }

        @Override
        public Uint32 getMaximumPacketSize() {
            return this._maximumPacketSize;
        }

        @Override
        public Uint32 getMinimumPolicedUnit() {
            return this._minimumPolicedUnit;
        }

        @Override
        public Float32 getPeakDataRate() {
            return this._peakDataRate;
        }

        @Override
        public Float32 getTokenBucketRate() {
            return this._tokenBucketRate;
        }

        @Override
        public Float32 getTokenBucketSize() {
            return this._tokenBucketSize;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._maximumPacketSize);
            result = 31 * result + Objects.hashCode(this._minimumPolicedUnit);
            result = 31 * result + Objects.hashCode(this._peakDataRate);
            result = 31 * result + Objects.hashCode(this._tokenBucketRate);
            result = 31 * result + Objects.hashCode(this._tokenBucketSize);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!TspecObject.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            TspecObject other = (TspecObject)obj;
            if (!Objects.equals(this._maximumPacketSize, other.getMaximumPacketSize())) {
                return false;
            }
            if (!Objects.equals(this._minimumPolicedUnit, other.getMinimumPolicedUnit())) {
                return false;
            }
            if (!Objects.equals(this._peakDataRate, other.getPeakDataRate())) {
                return false;
            }
            if (!Objects.equals(this._tokenBucketRate, other.getTokenBucketRate())) {
                return false;
            }
            if (!Objects.equals(this._tokenBucketSize, other.getTokenBucketSize())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                TspecObjectImpl otherImpl = (TspecObjectImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"TspecObject");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_maximumPacketSize", (Object)this._maximumPacketSize);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_minimumPolicedUnit", (Object)this._minimumPolicedUnit);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_peakDataRate", (Object)this._peakDataRate);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_tokenBucketRate", (Object)this._tokenBucketRate);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_tokenBucketSize", (Object)this._tokenBucketSize);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

