/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820;

import com.google.common.base.MoreObjects;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Base64;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.ScalarTypeObject;

public class PceId
implements ScalarTypeObject<byte[]>,
Serializable {
    private static final long serialVersionUID = -3775655423512102136L;
    private final byte[] _value;

    private static void check_valueLength(byte[] value) {
        int length = value.length;
        if (length == 4) {
            return;
        }
        if (length == 16) {
            return;
        }
        CodeHelpers.throwInvalidLength((String)"[[4..4], [16..16]]", (byte[])value);
    }

    @ConstructorParameters(value={"value"})
    @ConstructorProperties(value={"value"})
    public PceId(byte[] _value) {
        if (_value != null) {
            PceId.check_valueLength(_value);
        }
        CodeHelpers.requireValue((Object)_value);
        this._value = (byte[])_value.clone();
    }

    public PceId(PceId source) {
        this._value = source._value;
    }

    public static PceId getDefaultInstance(String defaultValue) {
        return new PceId(Base64.getDecoder().decode(defaultValue));
    }

    public byte[] getValue() {
        return (byte[])this._value.clone();
    }

    public int hashCode() {
        return CodeHelpers.wrapperHashCode((byte[])this._value);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PceId)) {
            return false;
        }
        PceId other = (PceId)obj;
        return Arrays.equals(this._value, other._value);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(PceId.class);
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_value", (byte[])this._value);
        return helper.toString();
    }
}

