/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.attribute.flags;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.attribute.flags.FlagContainer;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;

public class FlagContainerBuilder
implements Builder<FlagContainer> {
    private byte[] _flags;
    Map<Class<? extends Augmentation<FlagContainer>>, Augmentation<FlagContainer>> augmentation = Collections.emptyMap();

    public FlagContainerBuilder() {
    }

    public FlagContainerBuilder(FlagContainer base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<FlagContainer>>, Augmentation<FlagContainer>>(aug);
        }
        this._flags = base.getFlags();
    }

    public byte[] getFlags() {
        return this._flags == null ? null : (byte[])this._flags.clone();
    }

    public <E$$ extends Augmentation<FlagContainer>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    private static void check_flagsLength(byte[] value) {
        int length = value.length;
        if (length == 4) {
            return;
        }
        CodeHelpers.throwInvalidLength((String)"[[4..4]]", (byte[])value);
    }

    public FlagContainerBuilder setFlags(byte[] value) {
        if (value != null) {
            FlagContainerBuilder.check_flagsLength(value);
        }
        this._flags = value;
        return this;
    }

    public FlagContainerBuilder addAugmentation(Augmentation<FlagContainer> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<FlagContainer>>, Augmentation<FlagContainer>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public FlagContainerBuilder removeAugmentation(Class<? extends Augmentation<FlagContainer>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public FlagContainer build() {
        return new FlagContainerImpl(this);
    }

    private static final class FlagContainerImpl
    extends AbstractAugmentable<FlagContainer>
    implements FlagContainer {
        private final byte[] _flags;
        private int hash = 0;
        private volatile boolean hashValid = false;

        FlagContainerImpl(FlagContainerBuilder base) {
            super(base.augmentation);
            this._flags = base.getFlags();
        }

        @Override
        public byte[] getFlags() {
            return this._flags == null ? null : (byte[])this._flags.clone();
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = FlagContainer.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return FlagContainer.bindingEquals(this, obj);
        }

        public String toString() {
            return FlagContainer.bindingToString(this);
        }
    }
}

