package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>rsvp</b>
 * <pre>
 * grouping as-number-subobject {
 *   uses c-subobject;
 *   leaf as-number {
 *     type inet:as-number;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface AsNumberSubobject
    extends
    DataObject,
    CSubobject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("as-number-subobject");

    @Override
    Class<? extends AsNumberSubobject> implementedInterface();
    
    /**
     * Return asNumber, or {@code null} if it is not present.
     *
     * @return {@code AsNumber} asNumber, or {@code null} if it is not present.
     *
     */
    AsNumber getAsNumber();
    
    /**
     * Return asNumber, guaranteed to be non-null.
     *
     * @return {@code AsNumber} asNumber, guaranteed to be non-null.
     * @throws NoSuchElementException if asNumber is not present
     *
     */
    default @NonNull AsNumber requireAsNumber() {
        return CodeHelpers.require(getAsNumber(), "asnumber");
    }

}

