package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.Bandwidth;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>rsvp</b>
 * <pre>
 * grouping common-fast-reroute-object {
 *   uses rsvp-te-object;
 *   uses priority;
 *   uses attribute-filters;
 *   leaf hop-limit {
 *     type uint8;
 *     default 0;
 *   }
 *   leaf flags {
 *     type fast-reroute-flags;
 *   }
 *   leaf bandwidth {
 *     type netc:bandwidth;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface CommonFastRerouteObject
    extends
    DataObject,
    RsvpTeObject,
    Priority,
    AttributeFilters
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("common-fast-reroute-object");

    @Override
    Class<? extends CommonFastRerouteObject> implementedInterface();
    
    /**
     * Return hopLimit, or {@code null} if it is not present.
     *
     * @return {@code Uint8} hopLimit, or {@code null} if it is not present.
     *
     */
    Uint8 getHopLimit();
    
    /**
     * Return hopLimit, guaranteed to be non-null.
     *
     * @return {@code Uint8} hopLimit, guaranteed to be non-null.
     * @throws NoSuchElementException if hopLimit is not present
     *
     */
    default @NonNull Uint8 requireHopLimit() {
        return CodeHelpers.require(getHopLimit(), "hoplimit");
    }
    
    /**
     * Return flags, or {@code null} if it is not present.
     *
     * @return {@code FastRerouteFlags} flags, or {@code null} if it is not present.
     *
     */
    FastRerouteFlags getFlags();
    
    /**
     * Return flags, guaranteed to be non-null.
     *
     * @return {@code FastRerouteFlags} flags, guaranteed to be non-null.
     * @throws NoSuchElementException if flags is not present
     *
     */
    default @NonNull FastRerouteFlags requireFlags() {
        return CodeHelpers.require(getFlags(), "flags");
    }
    
    /**
     * Return bandwidth, or {@code null} if it is not present.
     *
     * @return {@code Bandwidth} bandwidth, or {@code null} if it is not present.
     *
     */
    Bandwidth getBandwidth();
    
    /**
     * Return bandwidth, guaranteed to be non-null.
     *
     * @return {@code Bandwidth} bandwidth, guaranteed to be non-null.
     * @throws NoSuchElementException if bandwidth is not present
     *
     */
    default @NonNull Bandwidth requireBandwidth() {
        return CodeHelpers.require(getBandwidth(), "bandwidth");
    }

}

