package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddressNoZone;
import org.opendaylight.yangtools.yang.binding.BitsTypeObject;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>rsvp</b>
 * <pre>
 * grouping error-spec {
 *   leaf node {
 *     type inet:ip-address-no-zone;
 *   }
 *   leaf flags {
 *     type bits {
 *       bit in-place {
 *         position 7;
 *       }
 *       bit not-guilty {
 *         position 6;
 *       }
 *     }
 *   }
 *   leaf code {
 *     type uint8;
 *   }
 *   leaf value {
 *     type uint16;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface ErrorSpec
    extends
    DataObject
{

    /**
     *
     * <p>
     * This class represents the following YANG schema fragment defined in module <b>rsvp</b>
     * <pre>
     * leaf flags {
     *   type bits {
     *     bit in-place {
     *       position 7;
     *     }
     *     bit not-guilty {
     *       position 6;
     *     }
     *   }
     * }
     * </pre>
     *
     */
    public static final class Flags
     implements BitsTypeObject, Serializable {
        @java.io.Serial
        private static final long serialVersionUID = -5216801750621581802L;
        protected static final ImmutableSet<String> VALID_NAMES = ImmutableSet.of("not-guilty", "in-place");
        private final boolean _notGuilty;
        private final boolean _inPlace;
    
    
        public Flags(boolean _inPlace, boolean _notGuilty) {
        
            this._notGuilty = _notGuilty;
            this._inPlace = _inPlace;
        }
        
        /**
         * Creates a copy from Source Object.
         *
         * @param source Source object
         */
        public Flags(Flags source) {
            this._notGuilty = source._notGuilty;
            this._inPlace = source._inPlace;
        }
    
    
        public boolean getNotGuilty() {
            return _notGuilty;
        }
        
        public boolean getInPlace() {
            return _inPlace;
        }
    
        
        @Override
        public ImmutableSet<String> validNames() {
            return VALID_NAMES;
        }
        
        @Override
        public boolean[] values() {
            return new boolean[] {
                    getNotGuilty(),
                    getInPlace()
                };
        }
    
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = 1;
            result = prime * result + Boolean.hashCode(_notGuilty);
            result = prime * result + Boolean.hashCode(_inPlace);
            return result;
        }
    
        @Override
        public final boolean equals(Object obj) {
            return this == obj || obj instanceof Flags other
                && _notGuilty == other._notGuilty        
                && _inPlace == other._inPlace;
        }
    
        @Override
        public String toString() {
            final var helper = MoreObjects.toStringHelper(Flags.class);
            CodeHelpers.appendBit(helper, "notGuilty", _notGuilty);
            CodeHelpers.appendBit(helper, "inPlace", _inPlace);
            return helper.toString();
        }
    }
    


    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("error-spec");

    @Override
    Class<? extends ErrorSpec> implementedInterface();
    
    /**
     * Return node, or {@code null} if it is not present.
     *
     * @return {@code IpAddressNoZone} node, or {@code null} if it is not present.
     *
     */
    IpAddressNoZone getNode();
    
    /**
     * Return node, guaranteed to be non-null.
     *
     * @return {@code IpAddressNoZone} node, guaranteed to be non-null.
     * @throws NoSuchElementException if node is not present
     *
     */
    default @NonNull IpAddressNoZone requireNode() {
        return CodeHelpers.require(getNode(), "node");
    }
    
    /**
     * Return flags, or {@code null} if it is not present.
     *
     * @return {@code Flags} flags, or {@code null} if it is not present.
     *
     */
    Flags getFlags();
    
    /**
     * Return flags, guaranteed to be non-null.
     *
     * @return {@code Flags} flags, guaranteed to be non-null.
     * @throws NoSuchElementException if flags is not present
     *
     */
    default @NonNull Flags requireFlags() {
        return CodeHelpers.require(getFlags(), "flags");
    }
    
    /**
     * Return code, or {@code null} if it is not present.
     *
     * @return {@code Uint8} code, or {@code null} if it is not present.
     *
     */
    Uint8 getCode();
    
    /**
     * Return code, guaranteed to be non-null.
     *
     * @return {@code Uint8} code, guaranteed to be non-null.
     * @throws NoSuchElementException if code is not present
     *
     */
    default @NonNull Uint8 requireCode() {
        return CodeHelpers.require(getCode(), "code");
    }
    
    /**
     * Return value, or {@code null} if it is not present.
     *
     * @return {@code Uint16} value, or {@code null} if it is not present.
     *
     */
    Uint16 getValue();
    
    /**
     * Return value, guaranteed to be non-null.
     *
     * @return {@code Uint16} value, guaranteed to be non-null.
     * @throws NoSuchElementException if value is not present
     *
     */
    default @NonNull Uint16 requireValue() {
        return CodeHelpers.require(getValue(), "value");
    }

}

