package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.lang.String;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.processing.Generated;
import javax.management.ConstructorParameters;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6AddressNoZone;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>rsvp</b>
 * <pre>
 * typedef ipv6-extended-tunnel-id {
 *   type inet:ipv6-address-no-zone;
 * }
 * </pre>
 *
 * @see Ipv6AddressNoZone
 *
 */
@Generated("mdsal-binding-generator")
public class Ipv6ExtendedTunnelId extends Ipv6AddressNoZone
 implements Serializable {
    @java.io.Serial
    private static final long serialVersionUID = 9074720655077108233L;
    public static final List<String> PATTERN_CONSTANTS = ImmutableList.of("^(?:[0-9a-fA-F:\\.]*)$");
    private static final Pattern patterns = Pattern.compile(PATTERN_CONSTANTS.get(0));
    private static final String regexes = "[0-9a-fA-F:\\.]*";


    @ConstructorParameters("value")
    public Ipv6ExtendedTunnelId(String _value) {
        super(_value);
        
        CodeHelpers.requireValue(_value);
        CodeHelpers.checkPattern(_value, patterns, regexes);
    
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public Ipv6ExtendedTunnelId(Ipv6ExtendedTunnelId source) {
        super(source);
    }
    /**
     * Creates a new instance from Ipv6AddressNoZone
     *
     * @param source Source object
     */
    public Ipv6ExtendedTunnelId(Ipv6AddressNoZone source) {
        super(source);
        CodeHelpers.checkPattern(getValue(), patterns, regexes);
    }

    public static Ipv6ExtendedTunnelId getDefaultInstance(final String defaultValue) {
        return new Ipv6ExtendedTunnelId(defaultValue);
    }





}

