package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.label.set.LabelType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.label.set.Subchannels;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.EnumTypeObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>rsvp</b>
 * <pre>
 * grouping label-set {
 *   leaf action {
 *     type enumeration {
 *       enum inclusive-list {
 *         value 0;
 *       }
 *       enum exclusive-list {
 *         value 1;
 *       }
 *       enum inclusive-range {
 *         value 2;
 *       }
 *       enum exclusive-range {
 *         value 3;
 *       }
 *     }
 *   }
 *   container label-type;
 *   list subchannels;
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface LabelSet
    extends
    DataObject
{


    /**
     *
     * <p>
     * This class represents the following YANG schema fragment defined in module <b>rsvp</b>
     * <pre>
     * leaf action {
     *   type enumeration {
     *     enum inclusive-list {
     *       value 0;
     *     }
     *     enum exclusive-list {
     *       value 1;
     *     }
     *     enum inclusive-range {
     *       value 2;
     *     }
     *     enum exclusive-range {
     *       value 3;
     *     }
     *   }
     * }
     * </pre>
     *
     */
    @Generated("mdsal-binding-generator")
    public enum Action implements EnumTypeObject {
        InclusiveList(0, "inclusive-list"),
        
        ExclusiveList(1, "exclusive-list"),
        
        InclusiveRange(2, "inclusive-range"),
        
        ExclusiveRange(3, "exclusive-range")
        ;
    
        private final @NonNull String name;
        private final int value;
    
        private Action(int value, @NonNull String name) {
            this.value = value;
            this.name = name;
        }
    
        @Override
        public @NonNull String getName() {
            return name;
        }
    
        @Override
        public int getIntValue() {
            return value;
        }
    
        /**
         * Return the enumeration member whose {@link #getName()} matches specified assigned name.
         *
         * @param name YANG assigned name
         * @return corresponding Action item, or {@code null} if no such item exists
         * @throws NullPointerException if {@code name} is null
         */
        public static @Nullable Action forName(String name) {
            return switch (name) {
                case "inclusive-list" -> InclusiveList;
                case "exclusive-list" -> ExclusiveList;
                case "inclusive-range" -> InclusiveRange;
                case "exclusive-range" -> ExclusiveRange;
                default -> null;
            };
        }
    
        /**
         * Return the enumeration member whose {@link #getIntValue()} matches specified value.
         *
         * @param intValue integer value
         * @return corresponding Action item, or {@code null} if no such item exists
         */
        public static @Nullable Action forValue(int intValue) {
            return switch (intValue) {
                case 0 -> InclusiveList;
                case 1 -> ExclusiveList;
                case 2 -> InclusiveRange;
                case 3 -> ExclusiveRange;
                default -> null;
            };
        }
    
        /**
         * Return the enumeration member whose {@link #getName()} matches specified assigned name.
         *
         * @param name YANG assigned name
         * @return corresponding Action item
         * @throws NullPointerException if {@code name} is null
         * @throws IllegalArgumentException if {@code name} does not match any item
         */
        public static @NonNull Action ofName(String name) {
            return CodeHelpers.checkEnum(forName(name), name);
        }
    
        /**
         * Return the enumeration member whose {@link #getIntValue()} matches specified value.
         *
         * @param intValue integer value
         * @return corresponding Action item
         * @throws IllegalArgumentException if {@code intValue} does not match any item
         */
        public static @NonNull Action ofValue(int intValue) {
            return CodeHelpers.checkEnum(forValue(intValue), intValue);
        }
    }

    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("label-set");

    @Override
    Class<? extends LabelSet> implementedInterface();
    
    /**
     * Return action, or {@code null} if it is not present.
     *
     * @return {@code Action} action, or {@code null} if it is not present.
     *
     */
    Action getAction();
    
    /**
     * Return action, guaranteed to be non-null.
     *
     * @return {@code Action} action, guaranteed to be non-null.
     * @throws NoSuchElementException if action is not present
     *
     */
    default @NonNull Action requireAction() {
        return CodeHelpers.require(getAction(), "action");
    }
    
    /**
     * Return labelType, or {@code null} if it is not present.
     *
     * @return {@code LabelType} labelType, or {@code null} if it is not present.
     *
     */
    LabelType getLabelType();
    
    /**
     * Return labelType, or an empty instance if it is not present.
     *
     * @return {@code LabelType} labelType, or an empty instance if it is not present.
     *
     */
    @NonNull LabelType nonnullLabelType();
    
    /**
     * Return subchannels, or {@code null} if it is not present.
     *
     * @return {@code List<Subchannels>} subchannels, or {@code null} if it is not present.
     *
     */
    @Nullable List<Subchannels> getSubchannels();
    
    /**
     * Return subchannels, or an empty list if it is not present.
     *
     * @return {@code List<Subchannels>} subchannels, or an empty list if it is not present.
     *
     */
    default @NonNull List<Subchannels> nonnullSubchannels() {
        return CodeHelpers.nonnull(getSubchannels());
    }

}

