package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820._record.route.subobjects.SubobjectType;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>rsvp</b>
 * <pre>
 * grouping record-route-subobjects {
 *   leaf protection-available {
 *     type boolean;
 *     default false;
 *   }
 *   leaf protection-in-use {
 *     type boolean;
 *     default false;
 *   }
 *   choice subobject-type {
 *     case ip-prefix-case {
 *       container ip-prefix {
 *         uses ip-prefix-subobject;
 *       }
 *     }
 *     case label-case {
 *       container label {
 *         uses label-subobject;
 *         leaf global {
 *           type boolean;
 *           default false;
 *         }
 *       }
 *     }
 *     case unnumbered-case {
 *       container unnumbered {
 *         uses unnumbered-subobject;
 *       }
 *     }
 *     case path-key-case {
 *       container path-key {
 *         uses path-key-subobject;
 *       }
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface RecordRouteSubobjects
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("record-route-subobjects");

    @Override
    Class<? extends RecordRouteSubobjects> implementedInterface();
    
    /**
     * Return protectionAvailable, or {@code null} if it is not present.
     *
     * @return {@code Boolean} protectionAvailable, or {@code null} if it is not present.
     *
     */
    Boolean getProtectionAvailable();
    
    /**
     * Return protectionAvailable, guaranteed to be non-null.
     *
     * @return {@code Boolean} protectionAvailable, guaranteed to be non-null.
     * @throws NoSuchElementException if protectionAvailable is not present
     *
     */
    default @NonNull Boolean requireProtectionAvailable() {
        return CodeHelpers.require(getProtectionAvailable(), "protectionavailable");
    }
    
    /**
     * Return protectionInUse, or {@code null} if it is not present.
     *
     * @return {@code Boolean} protectionInUse, or {@code null} if it is not present.
     *
     */
    Boolean getProtectionInUse();
    
    /**
     * Return protectionInUse, guaranteed to be non-null.
     *
     * @return {@code Boolean} protectionInUse, guaranteed to be non-null.
     * @throws NoSuchElementException if protectionInUse is not present
     *
     */
    default @NonNull Boolean requireProtectionInUse() {
        return CodeHelpers.require(getProtectionInUse(), "protectioninuse");
    }
    
    /**
     * Return subobjectType, or {@code null} if it is not present.
     *
     * @return {@code SubobjectType} subobjectType, or {@code null} if it is not present.
     *
     */
    SubobjectType getSubobjectType();

}

