package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>rsvp</b>
 * <pre>
 * grouping tunnel-attributes {
 *   uses priority;
 *   leaf local-protection-desired {
 *     type boolean;
 *     default false;
 *   }
 *   leaf label-recording-desired {
 *     type boolean;
 *     default false;
 *   }
 *   leaf se-style-desired {
 *     type boolean;
 *     default false;
 *   }
 *   leaf session-name {
 *     type string;
 *   }
 *   uses attribute-filters;
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface TunnelAttributes
    extends
    DataObject,
    Priority,
    AttributeFilters
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("tunnel-attributes");

    @Override
    Class<? extends TunnelAttributes> implementedInterface();
    
    /**
     * Return localProtectionDesired, or {@code null} if it is not present.
     *
     * @return {@code Boolean} localProtectionDesired, or {@code null} if it is not present.
     *
     */
    Boolean getLocalProtectionDesired();
    
    /**
     * Return localProtectionDesired, guaranteed to be non-null.
     *
     * @return {@code Boolean} localProtectionDesired, guaranteed to be non-null.
     * @throws NoSuchElementException if localProtectionDesired is not present
     *
     */
    default @NonNull Boolean requireLocalProtectionDesired() {
        return CodeHelpers.require(getLocalProtectionDesired(), "localprotectiondesired");
    }
    
    /**
     * Return labelRecordingDesired, or {@code null} if it is not present.
     *
     * @return {@code Boolean} labelRecordingDesired, or {@code null} if it is not present.
     *
     */
    Boolean getLabelRecordingDesired();
    
    /**
     * Return labelRecordingDesired, guaranteed to be non-null.
     *
     * @return {@code Boolean} labelRecordingDesired, guaranteed to be non-null.
     * @throws NoSuchElementException if labelRecordingDesired is not present
     *
     */
    default @NonNull Boolean requireLabelRecordingDesired() {
        return CodeHelpers.require(getLabelRecordingDesired(), "labelrecordingdesired");
    }
    
    /**
     * Return seStyleDesired, or {@code null} if it is not present.
     *
     * @return {@code Boolean} seStyleDesired, or {@code null} if it is not present.
     *
     */
    Boolean getSeStyleDesired();
    
    /**
     * Return seStyleDesired, guaranteed to be non-null.
     *
     * @return {@code Boolean} seStyleDesired, guaranteed to be non-null.
     * @throws NoSuchElementException if seStyleDesired is not present
     *
     */
    default @NonNull Boolean requireSeStyleDesired() {
        return CodeHelpers.require(getSeStyleDesired(), "sestyledesired");
    }
    
    /**
     * Return sessionName, or {@code null} if it is not present.
     *
     * @return {@code String} sessionName, or {@code null} if it is not present.
     *
     */
    String getSessionName();
    
    /**
     * Return sessionName, guaranteed to be non-null.
     *
     * @return {@code String} sessionName, guaranteed to be non-null.
     * @throws NoSuchElementException if sessionName is not present
     *
     */
    default @NonNull String requireSessionName() {
        return CodeHelpers.require(getSessionName(), "sessionname");
    }

}

