package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>rsvp</b>
 * <pre>
 * grouping unnumbered-subobject {
 *   uses c-subobject;
 *   leaf router-id {
 *     type uint32;
 *   }
 *   leaf interface-id {
 *     type uint32;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface UnnumberedSubobject
    extends
    DataObject,
    CSubobject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("unnumbered-subobject");

    @Override
    Class<? extends UnnumberedSubobject> implementedInterface();
    
    /**
     * Return routerId, or {@code null} if it is not present.
     *
     * @return {@code Uint32} routerId, or {@code null} if it is not present.
     *
     */
    Uint32 getRouterId();
    
    /**
     * Return routerId, guaranteed to be non-null.
     *
     * @return {@code Uint32} routerId, guaranteed to be non-null.
     * @throws NoSuchElementException if routerId is not present
     *
     */
    default @NonNull Uint32 requireRouterId() {
        return CodeHelpers.require(getRouterId(), "routerid");
    }
    
    /**
     * Return interfaceId, or {@code null} if it is not present.
     *
     * @return {@code Uint32} interfaceId, or {@code null} if it is not present.
     *
     */
    Uint32 getInterfaceId();
    
    /**
     * Return interfaceId, guaranteed to be non-null.
     *
     * @return {@code Uint32} interfaceId, guaranteed to be non-null.
     * @throws NoSuchElementException if interfaceId is not present
     *
     */
    default @NonNull Uint32 requireInterfaceId() {
        return CodeHelpers.require(getInterfaceId(), "interfaceid");
    }

}

