package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.iana.rev130816.EnterpriseNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.user.error.spec.Subobjects;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>rsvp</b>
 * <pre>
 * grouping user-error-spec {
 *   leaf enterprise {
 *     type iana:enterprise-number;
 *   }
 *   leaf sub-org {
 *     type uint8;
 *     default 0;
 *   }
 *   leaf value {
 *     type uint16;
 *   }
 *   leaf description {
 *     type string;
 *     default "";
 *   }
 *   container subobjects;
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface UserErrorSpec
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("user-error-spec");

    @Override
    Class<? extends UserErrorSpec> implementedInterface();
    
    /**
     * Return enterprise, or {@code null} if it is not present.
     *
     * @return {@code EnterpriseNumber} enterprise, or {@code null} if it is not present.
     *
     */
    EnterpriseNumber getEnterprise();
    
    /**
     * Return enterprise, guaranteed to be non-null.
     *
     * @return {@code EnterpriseNumber} enterprise, guaranteed to be non-null.
     * @throws NoSuchElementException if enterprise is not present
     *
     */
    default @NonNull EnterpriseNumber requireEnterprise() {
        return CodeHelpers.require(getEnterprise(), "enterprise");
    }
    
    /**
     * Return subOrg, or {@code null} if it is not present.
     *
     * @return {@code Uint8} subOrg, or {@code null} if it is not present.
     *
     */
    Uint8 getSubOrg();
    
    /**
     * Return subOrg, guaranteed to be non-null.
     *
     * @return {@code Uint8} subOrg, guaranteed to be non-null.
     * @throws NoSuchElementException if subOrg is not present
     *
     */
    default @NonNull Uint8 requireSubOrg() {
        return CodeHelpers.require(getSubOrg(), "suborg");
    }
    
    /**
     * Return value, or {@code null} if it is not present.
     *
     * @return {@code Uint16} value, or {@code null} if it is not present.
     *
     */
    Uint16 getValue();
    
    /**
     * Return value, guaranteed to be non-null.
     *
     * @return {@code Uint16} value, guaranteed to be non-null.
     * @throws NoSuchElementException if value is not present
     *
     */
    default @NonNull Uint16 requireValue() {
        return CodeHelpers.require(getValue(), "value");
    }
    
    /**
     * Return description, or {@code null} if it is not present.
     *
     * @return {@code String} description, or {@code null} if it is not present.
     *
     */
    String getDescription();
    
    /**
     * Return description, guaranteed to be non-null.
     *
     * @return {@code String} description, guaranteed to be non-null.
     * @throws NoSuchElementException if description is not present
     *
     */
    default @NonNull String requireDescription() {
        return CodeHelpers.require(getDescription(), "description");
    }
    
    /**
     * Return subobjects, or {@code null} if it is not present.
     *
     * @return {@code Subobjects} subobjects, or {@code null} if it is not present.
     *
     */
    Subobjects getSubobjects();
    
    /**
     * Return subobjects, or an empty instance if it is not present.
     *
     * @return {@code Subobjects} subobjects, or an empty instance if it is not present.
     *
     */
    @NonNull Subobjects nonnullSubobjects();

}

