package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>rsvp</b>
 * <pre>
 * grouping waveband-switching-label {
 *   uses c-label;
 *   leaf end-label {
 *     type uint32;
 *   }
 *   leaf start-label {
 *     type uint32;
 *   }
 *   leaf waveband-id {
 *     type uint32;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface WavebandSwitchingLabel
    extends
    DataObject,
    CLabel
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("waveband-switching-label");

    @Override
    Class<? extends WavebandSwitchingLabel> implementedInterface();
    
    /**
     * Return endLabel, or {@code null} if it is not present.
     *
     * @return {@code Uint32} endLabel, or {@code null} if it is not present.
     *
     */
    Uint32 getEndLabel();
    
    /**
     * Return endLabel, guaranteed to be non-null.
     *
     * @return {@code Uint32} endLabel, guaranteed to be non-null.
     * @throws NoSuchElementException if endLabel is not present
     *
     */
    default @NonNull Uint32 requireEndLabel() {
        return CodeHelpers.require(getEndLabel(), "endlabel");
    }
    
    /**
     * Return startLabel, or {@code null} if it is not present.
     *
     * @return {@code Uint32} startLabel, or {@code null} if it is not present.
     *
     */
    Uint32 getStartLabel();
    
    /**
     * Return startLabel, guaranteed to be non-null.
     *
     * @return {@code Uint32} startLabel, guaranteed to be non-null.
     * @throws NoSuchElementException if startLabel is not present
     *
     */
    default @NonNull Uint32 requireStartLabel() {
        return CodeHelpers.require(getStartLabel(), "startlabel");
    }
    
    /**
     * Return wavebandId, or {@code null} if it is not present.
     *
     * @return {@code Uint32} wavebandId, or {@code null} if it is not present.
     *
     */
    Uint32 getWavebandId();
    
    /**
     * Return wavebandId, guaranteed to be non-null.
     *
     * @return {@code Uint32} wavebandId, guaranteed to be non-null.
     * @throws NoSuchElementException if wavebandId is not present
     *
     */
    default @NonNull Uint32 requireWavebandId() {
        return CodeHelpers.require(getWavebandId(), "wavebandid");
    }

}

