package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.admin.status.object;
import com.google.common.base.MoreObjects;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.RsvpTeObject;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Admin Status Object
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>rsvp</b>
 * <pre>
 * container admin-status-object {
 *   uses rsvp-te-object;
 *   leaf reflect {
 *     type boolean;
 *     default false;
 *   }
 *   leaf testing {
 *     type boolean;
 *     default false;
 *   }
 *   leaf administratively-down {
 *     type boolean;
 *     default false;
 *   }
 *   leaf deletion-in-progress {
 *     type boolean;
 *     default false;
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link AdminStatusObjectBuilder}.
 * @see AdminStatusObjectBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface AdminStatusObject
    extends
    ChildOf<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AdminStatusObject>,
    Augmentable<AdminStatusObject>,
    RsvpTeObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("admin-status-object");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.admin.status.object.AdminStatusObject> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.admin.status.object.AdminStatusObject.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.admin.status.object.@NonNull AdminStatusObject obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getAdministrativelyDown());
        result = prime * result + Objects.hashCode(obj.getDeletionInProgress());
        result = prime * result + Objects.hashCode(obj.getReflect());
        result = prime * result + Objects.hashCode(obj.getTesting());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.admin.status.object.@NonNull AdminStatusObject thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.admin.status.object.AdminStatusObject.class, obj);
        return other != null
            && Objects.equals(thisObj.getAdministrativelyDown(), other.getAdministrativelyDown())
            && Objects.equals(thisObj.getDeletionInProgress(), other.getDeletionInProgress())
            && Objects.equals(thisObj.getReflect(), other.getReflect())
            && Objects.equals(thisObj.getTesting(), other.getTesting())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.admin.status.object.@NonNull AdminStatusObject obj) {
        final var helper = MoreObjects.toStringHelper("AdminStatusObject");
        CodeHelpers.appendValue(helper, "administrativelyDown", obj.getAdministrativelyDown());
        CodeHelpers.appendValue(helper, "deletionInProgress", obj.getDeletionInProgress());
        CodeHelpers.appendValue(helper, "reflect", obj.getReflect());
        CodeHelpers.appendValue(helper, "testing", obj.getTesting());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return reflect, or {@code null} if it is not present.
     *
     * @return {@code Boolean} reflect, or {@code null} if it is not present.
     *
     */
    Boolean getReflect();
    
    /**
     * Return reflect, guaranteed to be non-null.
     *
     * @return {@code Boolean} reflect, guaranteed to be non-null.
     * @throws NoSuchElementException if reflect is not present
     *
     */
    default @NonNull Boolean requireReflect() {
        return CodeHelpers.require(getReflect(), "reflect");
    }
    
    /**
     * Return testing, or {@code null} if it is not present.
     *
     * @return {@code Boolean} testing, or {@code null} if it is not present.
     *
     */
    Boolean getTesting();
    
    /**
     * Return testing, guaranteed to be non-null.
     *
     * @return {@code Boolean} testing, guaranteed to be non-null.
     * @throws NoSuchElementException if testing is not present
     *
     */
    default @NonNull Boolean requireTesting() {
        return CodeHelpers.require(getTesting(), "testing");
    }
    
    /**
     * Return administrativelyDown, or {@code null} if it is not present.
     *
     * @return {@code Boolean} administrativelyDown, or {@code null} if it is not present.
     *
     */
    Boolean getAdministrativelyDown();
    
    /**
     * Return administrativelyDown, guaranteed to be non-null.
     *
     * @return {@code Boolean} administrativelyDown, guaranteed to be non-null.
     * @throws NoSuchElementException if administrativelyDown is not present
     *
     */
    default @NonNull Boolean requireAdministrativelyDown() {
        return CodeHelpers.require(getAdministrativelyDown(), "administrativelydown");
    }
    
    /**
     * Return deletionInProgress, or {@code null} if it is not present.
     *
     * @return {@code Boolean} deletionInProgress, or {@code null} if it is not present.
     *
     */
    Boolean getDeletionInProgress();
    
    /**
     * Return deletionInProgress, guaranteed to be non-null.
     *
     * @return {@code Boolean} deletionInProgress, guaranteed to be non-null.
     * @throws NoSuchElementException if deletionInProgress is not present
     *
     */
    default @NonNull Boolean requireDeletionInProgress() {
        return CodeHelpers.require(getDeletionInProgress(), "deletioninprogress");
    }

}

