package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.association.object;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AssociationType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.RsvpTeObject;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint16;

/**
 * Association Object
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>rsvp</b>
 * <pre>
 * container association-object {
 *   uses rsvp-te-object;
 *   leaf association-type {
 *     type association-type;
 *   }
 *   leaf association-id {
 *     type uint16;
 *   }
 *   leaf ip-address {
 *     type inet:ip-address-no-zone;
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link AssociationObjectBuilder}.
 * @see AssociationObjectBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface AssociationObject
    extends
    ChildOf<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AssociationObject>,
    Augmentable<AssociationObject>,
    RsvpTeObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("association-object");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.association.object.AssociationObject> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.association.object.AssociationObject.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.association.object.@NonNull AssociationObject obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getAssociationId());
        result = prime * result + Objects.hashCode(obj.getAssociationType());
        result = prime * result + Objects.hashCode(obj.getIpAddress());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.association.object.@NonNull AssociationObject thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.association.object.AssociationObject.class, obj);
        return other != null
            && Objects.equals(thisObj.getAssociationId(), other.getAssociationId())
            && Objects.equals(thisObj.getAssociationType(), other.getAssociationType())
            && Objects.equals(thisObj.getIpAddress(), other.getIpAddress())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.association.object.@NonNull AssociationObject obj) {
        final var helper = MoreObjects.toStringHelper("AssociationObject");
        CodeHelpers.appendValue(helper, "associationId", obj.getAssociationId());
        CodeHelpers.appendValue(helper, "associationType", obj.getAssociationType());
        CodeHelpers.appendValue(helper, "ipAddress", obj.getIpAddress());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return associationType, or {@code null} if it is not present.
     *
     * @return {@code AssociationType} associationType, or {@code null} if it is not present.
     *
     */
    AssociationType getAssociationType();
    
    /**
     * Return associationType, guaranteed to be non-null.
     *
     * @return {@code AssociationType} associationType, guaranteed to be non-null.
     * @throws NoSuchElementException if associationType is not present
     *
     */
    default @NonNull AssociationType requireAssociationType() {
        return CodeHelpers.require(getAssociationType(), "associationtype");
    }
    
    /**
     * Return associationId, or {@code null} if it is not present.
     *
     * @return {@code Uint16} associationId, or {@code null} if it is not present.
     *
     */
    Uint16 getAssociationId();
    
    /**
     * Return associationId, guaranteed to be non-null.
     *
     * @return {@code Uint16} associationId, guaranteed to be non-null.
     * @throws NoSuchElementException if associationId is not present
     *
     */
    default @NonNull Uint16 requireAssociationId() {
        return CodeHelpers.require(getAssociationId(), "associationid");
    }
    
    /**
     * Return ipAddress, or {@code null} if it is not present.
     *
     * @return {@code IpAddressNoZone} ipAddress, or {@code null} if it is not present.
     *
     */
    IpAddressNoZone getIpAddress();
    
    /**
     * Return ipAddress, guaranteed to be non-null.
     *
     * @return {@code IpAddressNoZone} ipAddress, guaranteed to be non-null.
     * @throws NoSuchElementException if ipAddress is not present
     *
     */
    default @NonNull IpAddressNoZone requireIpAddress() {
        return CodeHelpers.require(getIpAddress(), "ipaddress");
    }

}

