package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.association.object;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AssociationType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.RsvpTeObject;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint16;

/**
 * Class that builds {@link AssociationObject} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     AssociationObject createAssociationObject(int fooXyzzy, int barBaz) {
 *         return new AssociationObjectBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of AssociationObject, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see AssociationObject
 *
 */
@Generated("mdsal-binding-generator")
public class AssociationObjectBuilder {

    private Uint16 _associationId;
    private AssociationType _associationType;
    private IpAddressNoZone _ipAddress;


    Map<Class<? extends Augmentation<AssociationObject>>, Augmentation<AssociationObject>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public AssociationObjectBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link RsvpTeObject}.
     *
     * @param arg RsvpTeObject from which the builder should be initialized
     */
    public AssociationObjectBuilder(RsvpTeObject arg) {
    }
    

    /**
     * Construct a builder initialized with state from specified {@link AssociationObject}.
     *
     * @param base AssociationObject from which the builder should be initialized
     */
    public AssociationObjectBuilder(AssociationObject base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._associationId = base.getAssociationId();
        this._associationType = base.getAssociationType();
        this._ipAddress = base.getIpAddress();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link RsvpTeObject}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof RsvpTeObject castArg) {
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[RsvpTeObject]");
    }

    private static final class LazyEmpty {
        static final @NonNull AssociationObject INSTANCE = new AssociationObjectBuilder().build();
    
        private LazyEmpty() {
            // Hidden on purpose
        }
    }
    
    /**
     * Get empty instance of AssociationObject.
     *
     * @return An empty {@link AssociationObject}
     */
    public static @NonNull AssociationObject empty() {
        return LazyEmpty.INSTANCE;
    }

    /**
     * Return current value associated with the property corresponding to {@link AssociationObject#getAssociationId()}.
     *
     * @return current value
     */
    public Uint16 getAssociationId() {
        return _associationId;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link AssociationObject#getAssociationType()}.
     *
     * @return current value
     */
    public AssociationType getAssociationType() {
        return _associationType;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link AssociationObject#getIpAddress()}.
     *
     * @return current value
     */
    public IpAddressNoZone getIpAddress() {
        return _ipAddress;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<AssociationObject>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link AssociationObject#getAssociationId()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public AssociationObjectBuilder setAssociationId(final Uint16 value) {
        this._associationId = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link AssociationObject#getAssociationType()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public AssociationObjectBuilder setAssociationType(final AssociationType value) {
        this._associationType = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link AssociationObject#getIpAddress()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public AssociationObjectBuilder setIpAddress(final IpAddressNoZone value) {
        this._ipAddress = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public AssociationObjectBuilder addAugmentation(Augmentation<AssociationObject> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public AssociationObjectBuilder removeAugmentation(Class<? extends Augmentation<AssociationObject>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link AssociationObject} instance.
     *
     * @return A new {@link AssociationObject} instance.
     */
    public @NonNull AssociationObject build() {
        return new AssociationObjectImpl(this);
    }

    private static final class AssociationObjectImpl
        extends AbstractAugmentable<AssociationObject>
        implements AssociationObject {
    
        private final Uint16 _associationId;
        private final AssociationType _associationType;
        private final IpAddressNoZone _ipAddress;
    
        AssociationObjectImpl(AssociationObjectBuilder base) {
            super(base.augmentation);
            this._associationId = base.getAssociationId();
            this._associationType = base.getAssociationType();
            this._ipAddress = base.getIpAddress();
        }
    
        @Override
        public Uint16 getAssociationId() {
            return _associationId;
        }
        
        @Override
        public AssociationType getAssociationType() {
            return _associationType;
        }
        
        @Override
        public IpAddressNoZone getIpAddress() {
            return _ipAddress;
        }
    
        
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = AssociationObject.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return AssociationObject.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return AssociationObject.bindingToString(this);
        }
    }
}
