package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.as.number._case.AsNumber;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

/**
 * Class that builds {@link AsNumberCase} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     AsNumberCase createAsNumberCase(int fooXyzzy, int barBaz) {
 *         return new AsNumberCaseBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of AsNumberCase, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see AsNumberCase
 *
 */
@Generated("mdsal-binding-generator")
public class AsNumberCaseBuilder {

    private AsNumber _asNumber;


    Map<Class<? extends Augmentation<AsNumberCase>>, Augmentation<AsNumberCase>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public AsNumberCaseBuilder() {
        // No-op
    }

    
    

    /**
     * Construct a builder initialized with state from specified {@link AsNumberCase}.
     *
     * @param base AsNumberCase from which the builder should be initialized
     */
    public AsNumberCaseBuilder(AsNumberCase base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._asNumber = base.getAsNumber();
    }



    /**
     * Return current value associated with the property corresponding to {@link AsNumberCase#getAsNumber()}.
     *
     * @return current value
     */
    public AsNumber getAsNumber() {
        return _asNumber;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<AsNumberCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link AsNumberCase#getAsNumber()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public AsNumberCaseBuilder setAsNumber(final AsNumber value) {
        this._asNumber = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public AsNumberCaseBuilder addAugmentation(Augmentation<AsNumberCase> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public AsNumberCaseBuilder removeAugmentation(Class<? extends Augmentation<AsNumberCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link AsNumberCase} instance.
     *
     * @return A new {@link AsNumberCase} instance.
     */
    public @NonNull AsNumberCase build() {
        return new AsNumberCaseImpl(this);
    }

    private static final class AsNumberCaseImpl
        extends AbstractAugmentable<AsNumberCase>
        implements AsNumberCase {
    
        private final AsNumber _asNumber;
    
        AsNumberCaseImpl(AsNumberCaseBuilder base) {
            super(base.augmentation);
            this._asNumber = base.getAsNumber();
        }
    
        @Override
        public AsNumber getAsNumber() {
            return _asNumber;
        }
    
        @Override
        public AsNumber nonnullAsNumber() {
            return Objects.requireNonNullElse(getAsNumber(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.as.number._case.AsNumberBuilder.empty());
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = AsNumberCase.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return AsNumberCase.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return AsNumberCase.bindingToString(this);
        }
    }
}
