package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.label._case.Label;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

/**
 * Class that builds {@link LabelCase} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     LabelCase createLabelCase(int fooXyzzy, int barBaz) {
 *         return new LabelCaseBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of LabelCase, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see LabelCase
 *
 */
@Generated("mdsal-binding-generator")
public class LabelCaseBuilder {

    private Label _label;


    Map<Class<? extends Augmentation<LabelCase>>, Augmentation<LabelCase>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public LabelCaseBuilder() {
        // No-op
    }

    
    

    /**
     * Construct a builder initialized with state from specified {@link LabelCase}.
     *
     * @param base LabelCase from which the builder should be initialized
     */
    public LabelCaseBuilder(LabelCase base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._label = base.getLabel();
    }



    /**
     * Return current value associated with the property corresponding to {@link LabelCase#getLabel()}.
     *
     * @return current value
     */
    public Label getLabel() {
        return _label;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<LabelCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link LabelCase#getLabel()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public LabelCaseBuilder setLabel(final Label value) {
        this._label = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public LabelCaseBuilder addAugmentation(Augmentation<LabelCase> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public LabelCaseBuilder removeAugmentation(Class<? extends Augmentation<LabelCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link LabelCase} instance.
     *
     * @return A new {@link LabelCase} instance.
     */
    public @NonNull LabelCase build() {
        return new LabelCaseImpl(this);
    }

    private static final class LabelCaseImpl
        extends AbstractAugmentable<LabelCase>
        implements LabelCase {
    
        private final Label _label;
    
        LabelCaseImpl(LabelCaseBuilder base) {
            super(base.augmentation);
            this._label = base.getLabel();
        }
    
        @Override
        public Label getLabel() {
            return _label;
        }
    
        @Override
        public Label nonnullLabel() {
            return Objects.requireNonNullElse(getLabel(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.label._case.LabelBuilder.empty());
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = LabelCase.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return LabelCase.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return LabelCase.bindingToString(this);
        }
    }
}
