package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.label._case;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.CSubobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.LabelSubobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.label.subobject.LabelType;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link Label} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Label createLabel(int fooXyzzy, int barBaz) {
 *         return new LabelBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Label, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Label
 *
 */
@Generated("mdsal-binding-generator")
public class LabelBuilder {

    private LabelType _labelType;
    private Boolean _uniDirectional;


    Map<Class<? extends Augmentation<Label>>, Augmentation<Label>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public LabelBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link LabelSubobject}.
     *
     * @param arg LabelSubobject from which the builder should be initialized
     */
    public LabelBuilder(LabelSubobject arg) {
        this._uniDirectional = arg.getUniDirectional();
        this._labelType = arg.getLabelType();
    }
    
    /**
     * Construct a new builder initialized from specified {@link CSubobject}.
     *
     * @param arg CSubobject from which the builder should be initialized
     */
    public LabelBuilder(CSubobject arg) {
    }
    

    /**
     * Construct a builder initialized with state from specified {@link Label}.
     *
     * @param base Label from which the builder should be initialized
     */
    public LabelBuilder(Label base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._labelType = base.getLabelType();
        this._uniDirectional = base.getUniDirectional();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link LabelSubobject}</li>
     *   <li>{@link CSubobject}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof LabelSubobject castArg) {
            this._uniDirectional = castArg.getUniDirectional();
            this._labelType = castArg.getLabelType();
            isValidArg = true;
        }
        if (arg instanceof CSubobject castArg) {
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[LabelSubobject, CSubobject]");
    }

    private static final class LazyEmpty {
        static final @NonNull Label INSTANCE = new LabelBuilder().build();
    
        private LazyEmpty() {
            // Hidden on purpose
        }
    }
    
    /**
     * Get empty instance of Label.
     *
     * @return An empty {@link Label}
     */
    public static @NonNull Label empty() {
        return LazyEmpty.INSTANCE;
    }

    /**
     * Return current value associated with the property corresponding to {@link Label#getLabelType()}.
     *
     * @return current value
     */
    public LabelType getLabelType() {
        return _labelType;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Label#getUniDirectional()}.
     *
     * @return current value
     */
    public Boolean getUniDirectional() {
        return _uniDirectional;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Label>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link Label#getLabelType()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public LabelBuilder setLabelType(final LabelType value) {
        this._labelType = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Label#getUniDirectional()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public LabelBuilder setUniDirectional(final Boolean value) {
        this._uniDirectional = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public LabelBuilder addAugmentation(Augmentation<Label> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public LabelBuilder removeAugmentation(Class<? extends Augmentation<Label>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Label} instance.
     *
     * @return A new {@link Label} instance.
     */
    public @NonNull Label build() {
        return new LabelImpl(this);
    }

    private static final class LabelImpl
        extends AbstractAugmentable<Label>
        implements Label {
    
        private final LabelType _labelType;
        private final Boolean _uniDirectional;
    
        LabelImpl(LabelBuilder base) {
            super(base.augmentation);
            this._labelType = base.getLabelType();
            this._uniDirectional = base.getUniDirectional();
        }
    
        @Override
        public LabelType getLabelType() {
            return _labelType;
        }
        
        @Override
        public Boolean getUniDirectional() {
            return _uniDirectional;
        }
    
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Label.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Label.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Label.bindingToString(this);
        }
    }
}
