package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.unnumbered._case;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.CSubobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.UnnumberedSubobject;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Class that builds {@link Unnumbered} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Unnumbered createUnnumbered(int fooXyzzy, int barBaz) {
 *         return new UnnumberedBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Unnumbered, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Unnumbered
 *
 */
@Generated("mdsal-binding-generator")
public class UnnumberedBuilder {

    private Uint32 _interfaceId;
    private Uint32 _routerId;


    Map<Class<? extends Augmentation<Unnumbered>>, Augmentation<Unnumbered>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public UnnumberedBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link UnnumberedSubobject}.
     *
     * @param arg UnnumberedSubobject from which the builder should be initialized
     */
    public UnnumberedBuilder(UnnumberedSubobject arg) {
        this._routerId = arg.getRouterId();
        this._interfaceId = arg.getInterfaceId();
    }
    
    /**
     * Construct a new builder initialized from specified {@link CSubobject}.
     *
     * @param arg CSubobject from which the builder should be initialized
     */
    public UnnumberedBuilder(CSubobject arg) {
    }
    

    /**
     * Construct a builder initialized with state from specified {@link Unnumbered}.
     *
     * @param base Unnumbered from which the builder should be initialized
     */
    public UnnumberedBuilder(Unnumbered base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._interfaceId = base.getInterfaceId();
        this._routerId = base.getRouterId();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link UnnumberedSubobject}</li>
     *   <li>{@link CSubobject}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof UnnumberedSubobject castArg) {
            this._routerId = castArg.getRouterId();
            this._interfaceId = castArg.getInterfaceId();
            isValidArg = true;
        }
        if (arg instanceof CSubobject castArg) {
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[UnnumberedSubobject, CSubobject]");
    }

    private static final class LazyEmpty {
        static final @NonNull Unnumbered INSTANCE = new UnnumberedBuilder().build();
    
        private LazyEmpty() {
            // Hidden on purpose
        }
    }
    
    /**
     * Get empty instance of Unnumbered.
     *
     * @return An empty {@link Unnumbered}
     */
    public static @NonNull Unnumbered empty() {
        return LazyEmpty.INSTANCE;
    }

    /**
     * Return current value associated with the property corresponding to {@link Unnumbered#getInterfaceId()}.
     *
     * @return current value
     */
    public Uint32 getInterfaceId() {
        return _interfaceId;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Unnumbered#getRouterId()}.
     *
     * @return current value
     */
    public Uint32 getRouterId() {
        return _routerId;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Unnumbered>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link Unnumbered#getInterfaceId()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public UnnumberedBuilder setInterfaceId(final Uint32 value) {
        this._interfaceId = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Unnumbered#getRouterId()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public UnnumberedBuilder setRouterId(final Uint32 value) {
        this._routerId = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public UnnumberedBuilder addAugmentation(Augmentation<Unnumbered> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public UnnumberedBuilder removeAugmentation(Class<? extends Augmentation<Unnumbered>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Unnumbered} instance.
     *
     * @return A new {@link Unnumbered} instance.
     */
    public @NonNull Unnumbered build() {
        return new UnnumberedImpl(this);
    }

    private static final class UnnumberedImpl
        extends AbstractAugmentable<Unnumbered>
        implements Unnumbered {
    
        private final Uint32 _interfaceId;
        private final Uint32 _routerId;
    
        UnnumberedImpl(UnnumberedBuilder base) {
            super(base.augmentation);
            this._interfaceId = base.getInterfaceId();
            this._routerId = base.getRouterId();
        }
    
        @Override
        public Uint32 getInterfaceId() {
            return _interfaceId;
        }
        
        @Override
        public Uint32 getRouterId() {
            return _routerId;
        }
    
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Unnumbered.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Unnumbered.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Unnumbered.bindingToString(this);
        }
    }
}
