package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.explicit.route.subobjects.subobject.type.path.key._case;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.CSubobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.PathKeySubobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.PceId;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link PathKey} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     PathKey createPathKey(int fooXyzzy, int barBaz) {
 *         return new PathKeyBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of PathKey, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see PathKey
 *
 */
@Generated("mdsal-binding-generator")
public class PathKeyBuilder {

    private org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.PathKey _pathKey;
    private PceId _pceId;


    Map<Class<? extends Augmentation<PathKey>>, Augmentation<PathKey>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public PathKeyBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link PathKeySubobject}.
     *
     * @param arg PathKeySubobject from which the builder should be initialized
     */
    public PathKeyBuilder(PathKeySubobject arg) {
        this._pceId = arg.getPceId();
        this._pathKey = arg.getPathKey();
    }
    
    /**
     * Construct a new builder initialized from specified {@link CSubobject}.
     *
     * @param arg CSubobject from which the builder should be initialized
     */
    public PathKeyBuilder(CSubobject arg) {
    }
    

    /**
     * Construct a builder initialized with state from specified {@link PathKey}.
     *
     * @param base PathKey from which the builder should be initialized
     */
    public PathKeyBuilder(PathKey base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._pathKey = base.getPathKey();
        this._pceId = base.getPceId();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link PathKeySubobject}</li>
     *   <li>{@link CSubobject}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof PathKeySubobject castArg) {
            this._pceId = castArg.getPceId();
            this._pathKey = castArg.getPathKey();
            isValidArg = true;
        }
        if (arg instanceof CSubobject castArg) {
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[PathKeySubobject, CSubobject]");
    }

    private static final class LazyEmpty {
        static final @NonNull PathKey INSTANCE = new PathKeyBuilder().build();
    
        private LazyEmpty() {
            // Hidden on purpose
        }
    }
    
    /**
     * Get empty instance of PathKey.
     *
     * @return An empty {@link PathKey}
     */
    public static @NonNull PathKey empty() {
        return LazyEmpty.INSTANCE;
    }

    /**
     * Return current value associated with the property corresponding to {@link PathKey#getPathKey()}.
     *
     * @return current value
     */
    public org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.PathKey getPathKey() {
        return _pathKey;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link PathKey#getPceId()}.
     *
     * @return current value
     */
    public PceId getPceId() {
        return _pceId;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<PathKey>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link PathKey#getPathKey()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public PathKeyBuilder setPathKey(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.PathKey value) {
        this._pathKey = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link PathKey#getPceId()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public PathKeyBuilder setPceId(final PceId value) {
        this._pceId = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public PathKeyBuilder addAugmentation(Augmentation<PathKey> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public PathKeyBuilder removeAugmentation(Class<? extends Augmentation<PathKey>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link PathKey} instance.
     *
     * @return A new {@link PathKey} instance.
     */
    public @NonNull PathKey build() {
        return new PathKeyImpl(this);
    }

    private static final class PathKeyImpl
        extends AbstractAugmentable<PathKey>
        implements PathKey {
    
        private final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.PathKey _pathKey;
        private final PceId _pceId;
    
        PathKeyImpl(PathKeyBuilder base) {
            super(base.augmentation);
            this._pathKey = base.getPathKey();
            this._pceId = base.getPceId();
        }
    
        @Override
        public org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.PathKey getPathKey() {
            return _pathKey;
        }
        
        @Override
        public PceId getPceId() {
            return _pceId;
        }
    
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = PathKey.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return PathKey.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return PathKey.bindingToString(this);
        }
    }
}
