package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.label.subobject.label.type;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.label.subobject.label.type.type1.label._case.Type1Label;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

/**
 * Class that builds {@link Type1LabelCase} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Type1LabelCase createType1LabelCase(int fooXyzzy, int barBaz) {
 *         return new Type1LabelCaseBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Type1LabelCase, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Type1LabelCase
 *
 */
@Generated("mdsal-binding-generator")
public class Type1LabelCaseBuilder {

    private Type1Label _type1Label;


    Map<Class<? extends Augmentation<Type1LabelCase>>, Augmentation<Type1LabelCase>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public Type1LabelCaseBuilder() {
        // No-op
    }

    
    

    /**
     * Construct a builder initialized with state from specified {@link Type1LabelCase}.
     *
     * @param base Type1LabelCase from which the builder should be initialized
     */
    public Type1LabelCaseBuilder(Type1LabelCase base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._type1Label = base.getType1Label();
    }



    /**
     * Return current value associated with the property corresponding to {@link Type1LabelCase#getType1Label()}.
     *
     * @return current value
     */
    public Type1Label getType1Label() {
        return _type1Label;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Type1LabelCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link Type1LabelCase#getType1Label()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public Type1LabelCaseBuilder setType1Label(final Type1Label value) {
        this._type1Label = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public Type1LabelCaseBuilder addAugmentation(Augmentation<Type1LabelCase> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public Type1LabelCaseBuilder removeAugmentation(Class<? extends Augmentation<Type1LabelCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Type1LabelCase} instance.
     *
     * @return A new {@link Type1LabelCase} instance.
     */
    public @NonNull Type1LabelCase build() {
        return new Type1LabelCaseImpl(this);
    }

    private static final class Type1LabelCaseImpl
        extends AbstractAugmentable<Type1LabelCase>
        implements Type1LabelCase {
    
        private final Type1Label _type1Label;
    
        Type1LabelCaseImpl(Type1LabelCaseBuilder base) {
            super(base.augmentation);
            this._type1Label = base.getType1Label();
        }
    
        @Override
        public Type1Label getType1Label() {
            return _type1Label;
        }
    
        @Override
        public Type1Label nonnullType1Label() {
            return Objects.requireNonNullElse(getType1Label(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.label.subobject.label.type.type1.label._case.Type1LabelBuilder.empty());
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Type1LabelCase.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Type1LabelCase.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Type1LabelCase.bindingToString(this);
        }
    }
}
