package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.label.subobject.label.type.generalized.label._case;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.CLabel;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link GeneralizedLabel} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     GeneralizedLabel createGeneralizedLabel(int fooXyzzy, int barBaz) {
 *         return new GeneralizedLabelBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of GeneralizedLabel, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see GeneralizedLabel
 *
 */
@Generated("mdsal-binding-generator")
public class GeneralizedLabelBuilder {

    private byte[] _generalizedLabel;


    Map<Class<? extends Augmentation<GeneralizedLabel>>, Augmentation<GeneralizedLabel>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public GeneralizedLabelBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.GeneralizedLabel}.
     *
     * @param arg org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.GeneralizedLabel from which the builder should be initialized
     */
    public GeneralizedLabelBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.GeneralizedLabel arg) {
        this._generalizedLabel = arg.getGeneralizedLabel();
    }
    
    /**
     * Construct a new builder initialized from specified {@link CLabel}.
     *
     * @param arg CLabel from which the builder should be initialized
     */
    public GeneralizedLabelBuilder(CLabel arg) {
    }
    

    /**
     * Construct a builder initialized with state from specified {@link GeneralizedLabel}.
     *
     * @param base GeneralizedLabel from which the builder should be initialized
     */
    public GeneralizedLabelBuilder(GeneralizedLabel base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._generalizedLabel = base.getGeneralizedLabel();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.GeneralizedLabel}</li>
     *   <li>{@link CLabel}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.GeneralizedLabel castArg) {
            this._generalizedLabel = castArg.getGeneralizedLabel();
            isValidArg = true;
        }
        if (arg instanceof CLabel castArg) {
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.GeneralizedLabel, CLabel]");
    }

    private static final class LazyEmpty {
        static final @NonNull GeneralizedLabel INSTANCE = new GeneralizedLabelBuilder().build();
    
        private LazyEmpty() {
            // Hidden on purpose
        }
    }
    
    /**
     * Get empty instance of GeneralizedLabel.
     *
     * @return An empty {@link GeneralizedLabel}
     */
    public static @NonNull GeneralizedLabel empty() {
        return LazyEmpty.INSTANCE;
    }

    /**
     * Return current value associated with the property corresponding to {@link GeneralizedLabel#getGeneralizedLabel()}.
     *
     * @return current value
     */
    public byte[] getGeneralizedLabel() {
        return _generalizedLabel == null ? null : _generalizedLabel.clone();
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<GeneralizedLabel>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link GeneralizedLabel#getGeneralizedLabel()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public GeneralizedLabelBuilder setGeneralizedLabel(final byte[] value) {
        this._generalizedLabel = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public GeneralizedLabelBuilder addAugmentation(Augmentation<GeneralizedLabel> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public GeneralizedLabelBuilder removeAugmentation(Class<? extends Augmentation<GeneralizedLabel>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link GeneralizedLabel} instance.
     *
     * @return A new {@link GeneralizedLabel} instance.
     */
    public @NonNull GeneralizedLabel build() {
        return new GeneralizedLabelImpl(this);
    }

    private static final class GeneralizedLabelImpl
        extends AbstractAugmentable<GeneralizedLabel>
        implements GeneralizedLabel {
    
        private final byte[] _generalizedLabel;
    
        GeneralizedLabelImpl(GeneralizedLabelBuilder base) {
            super(base.augmentation);
            this._generalizedLabel = base.getGeneralizedLabel();
        }
    
        @Override
        public byte[] getGeneralizedLabel() {
            return _generalizedLabel == null ? null : _generalizedLabel.clone();
        }
    
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = GeneralizedLabel.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return GeneralizedLabel.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return GeneralizedLabel.bindingToString(this);
        }
    }
}
