package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.lsp.att.subobject.lsp.subobject;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.attribute.flags.FlagContainer;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link FlagsTlv} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     FlagsTlv createFlagsTlv(int fooXyzzy, int barBaz) {
 *         return new FlagsTlvBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of FlagsTlv, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see FlagsTlv
 *
 */
@Generated("mdsal-binding-generator")
public class FlagsTlvBuilder {

    private List<FlagContainer> _flagContainer;


    Map<Class<? extends Augmentation<FlagsTlv>>, Augmentation<FlagsTlv>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public FlagsTlvBuilder() {
        // No-op
    }

    
    
    
    /**
     * Construct a new builder initialized from specified {@link AttributeFlags}.
     *
     * @param arg AttributeFlags from which the builder should be initialized
     */
    public FlagsTlvBuilder(AttributeFlags arg) {
        this._flagContainer = arg.getFlagContainer();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link FlagsTlv}.
     *
     * @param base FlagsTlv from which the builder should be initialized
     */
    public FlagsTlvBuilder(FlagsTlv base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._flagContainer = base.getFlagContainer();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link AttributeFlags}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof AttributeFlags castArg) {
            this._flagContainer = castArg.getFlagContainer();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[AttributeFlags]");
    }


    /**
     * Return current value associated with the property corresponding to {@link FlagsTlv#getFlagContainer()}.
     *
     * @return current value
     */
    public List<FlagContainer> getFlagContainer() {
        return _flagContainer;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<FlagsTlv>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link FlagsTlv#getFlagContainer()} to the specified
     * value.
     *
     * @param values desired value
     * @return this builder
     */
    public FlagsTlvBuilder setFlagContainer(final List<FlagContainer> values) {
        this._flagContainer = values;
        return this;
    }
    
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public FlagsTlvBuilder addAugmentation(Augmentation<FlagsTlv> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public FlagsTlvBuilder removeAugmentation(Class<? extends Augmentation<FlagsTlv>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link FlagsTlv} instance.
     *
     * @return A new {@link FlagsTlv} instance.
     */
    public @NonNull FlagsTlv build() {
        return new FlagsTlvImpl(this);
    }

    private static final class FlagsTlvImpl
        extends AbstractAugmentable<FlagsTlv>
        implements FlagsTlv {
    
        private final List<FlagContainer> _flagContainer;
    
        FlagsTlvImpl(FlagsTlvBuilder base) {
            super(base.augmentation);
            this._flagContainer = CodeHelpers.emptyToNull(base.getFlagContainer());
        }
    
        @Override
        public List<FlagContainer> getFlagContainer() {
            return _flagContainer;
        }
    
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = FlagsTlv.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return FlagsTlv.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return FlagsTlv.bindingToString(this);
        }
    }
}
