package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.protection.subobject;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.LinkFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.LspFlag;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

/**
 * Class that builds {@link ProtectionSubobject} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     ProtectionSubobject createProtectionSubobject(int fooXyzzy, int barBaz) {
 *         return new ProtectionSubobjectBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of ProtectionSubobject, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see ProtectionSubobject
 *
 */
@Generated("mdsal-binding-generator")
public class ProtectionSubobjectBuilder {

    private Boolean _inPlace;
    private LinkFlags _linkFlags;
    private LspFlag _lspFlag;
    private Boolean _notification;
    private Boolean _operational;
    private Boolean _protecting;
    private Boolean _required;
    private Boolean _secondary;
    private LspFlag _segFlag;


    Map<Class<? extends Augmentation<ProtectionSubobject>>, Augmentation<ProtectionSubobject>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public ProtectionSubobjectBuilder() {
        // No-op
    }

    

    /**
     * Construct a builder initialized with state from specified {@link ProtectionSubobject}.
     *
     * @param base ProtectionSubobject from which the builder should be initialized
     */
    public ProtectionSubobjectBuilder(ProtectionSubobject base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._inPlace = base.getInPlace();
        this._linkFlags = base.getLinkFlags();
        this._lspFlag = base.getLspFlag();
        this._notification = base.getNotification();
        this._operational = base.getOperational();
        this._protecting = base.getProtecting();
        this._required = base.getRequired();
        this._secondary = base.getSecondary();
        this._segFlag = base.getSegFlag();
    }


    private static final class LazyEmpty {
        static final @NonNull ProtectionSubobject INSTANCE = new ProtectionSubobjectBuilder().build();
    
        private LazyEmpty() {
            // Hidden on purpose
        }
    }
    
    /**
     * Get empty instance of ProtectionSubobject.
     *
     * @return An empty {@link ProtectionSubobject}
     */
    public static @NonNull ProtectionSubobject empty() {
        return LazyEmpty.INSTANCE;
    }

    /**
     * Return current value associated with the property corresponding to {@link ProtectionSubobject#getInPlace()}.
     *
     * @return current value
     */
    public Boolean getInPlace() {
        return _inPlace;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link ProtectionSubobject#getLinkFlags()}.
     *
     * @return current value
     */
    public LinkFlags getLinkFlags() {
        return _linkFlags;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link ProtectionSubobject#getLspFlag()}.
     *
     * @return current value
     */
    public LspFlag getLspFlag() {
        return _lspFlag;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link ProtectionSubobject#getNotification()}.
     *
     * @return current value
     */
    public Boolean getNotification() {
        return _notification;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link ProtectionSubobject#getOperational()}.
     *
     * @return current value
     */
    public Boolean getOperational() {
        return _operational;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link ProtectionSubobject#getProtecting()}.
     *
     * @return current value
     */
    public Boolean getProtecting() {
        return _protecting;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link ProtectionSubobject#getRequired()}.
     *
     * @return current value
     */
    public Boolean getRequired() {
        return _required;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link ProtectionSubobject#getSecondary()}.
     *
     * @return current value
     */
    public Boolean getSecondary() {
        return _secondary;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link ProtectionSubobject#getSegFlag()}.
     *
     * @return current value
     */
    public LspFlag getSegFlag() {
        return _segFlag;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<ProtectionSubobject>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link ProtectionSubobject#getInPlace()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ProtectionSubobjectBuilder setInPlace(final Boolean value) {
        this._inPlace = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link ProtectionSubobject#getLinkFlags()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ProtectionSubobjectBuilder setLinkFlags(final LinkFlags value) {
        this._linkFlags = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link ProtectionSubobject#getLspFlag()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ProtectionSubobjectBuilder setLspFlag(final LspFlag value) {
        this._lspFlag = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link ProtectionSubobject#getNotification()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ProtectionSubobjectBuilder setNotification(final Boolean value) {
        this._notification = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link ProtectionSubobject#getOperational()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ProtectionSubobjectBuilder setOperational(final Boolean value) {
        this._operational = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link ProtectionSubobject#getProtecting()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ProtectionSubobjectBuilder setProtecting(final Boolean value) {
        this._protecting = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link ProtectionSubobject#getRequired()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ProtectionSubobjectBuilder setRequired(final Boolean value) {
        this._required = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link ProtectionSubobject#getSecondary()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ProtectionSubobjectBuilder setSecondary(final Boolean value) {
        this._secondary = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link ProtectionSubobject#getSegFlag()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ProtectionSubobjectBuilder setSegFlag(final LspFlag value) {
        this._segFlag = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public ProtectionSubobjectBuilder addAugmentation(Augmentation<ProtectionSubobject> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public ProtectionSubobjectBuilder removeAugmentation(Class<? extends Augmentation<ProtectionSubobject>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link ProtectionSubobject} instance.
     *
     * @return A new {@link ProtectionSubobject} instance.
     */
    public @NonNull ProtectionSubobject build() {
        return new ProtectionSubobjectImpl(this);
    }

    private static final class ProtectionSubobjectImpl
        extends AbstractAugmentable<ProtectionSubobject>
        implements ProtectionSubobject {
    
        private final Boolean _inPlace;
        private final LinkFlags _linkFlags;
        private final LspFlag _lspFlag;
        private final Boolean _notification;
        private final Boolean _operational;
        private final Boolean _protecting;
        private final Boolean _required;
        private final Boolean _secondary;
        private final LspFlag _segFlag;
    
        ProtectionSubobjectImpl(ProtectionSubobjectBuilder base) {
            super(base.augmentation);
            this._inPlace = base.getInPlace();
            this._linkFlags = base.getLinkFlags();
            this._lspFlag = base.getLspFlag();
            this._notification = base.getNotification();
            this._operational = base.getOperational();
            this._protecting = base.getProtecting();
            this._required = base.getRequired();
            this._secondary = base.getSecondary();
            this._segFlag = base.getSegFlag();
        }
    
        @Override
        public Boolean getInPlace() {
            return _inPlace;
        }
        
        @Override
        public LinkFlags getLinkFlags() {
            return _linkFlags;
        }
        
        @Override
        public LspFlag getLspFlag() {
            return _lspFlag;
        }
        
        @Override
        public Boolean getNotification() {
            return _notification;
        }
        
        @Override
        public Boolean getOperational() {
            return _operational;
        }
        
        @Override
        public Boolean getProtecting() {
            return _protecting;
        }
        
        @Override
        public Boolean getRequired() {
            return _required;
        }
        
        @Override
        public Boolean getSecondary() {
            return _secondary;
        }
        
        @Override
        public LspFlag getSegFlag() {
            return _segFlag;
        }
    
        
        
        
        
        
        
        
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = ProtectionSubobject.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return ProtectionSubobject.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return ProtectionSubobject.bindingToString(this);
        }
    }
}
