package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.secondary._record.route.object;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.RsvpTeObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.secondary._record.route.object.secondary._record.route.object.SubobjectContainer;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link SecondaryRecordRouteObject} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     SecondaryRecordRouteObject createSecondaryRecordRouteObject(int fooXyzzy, int barBaz) {
 *         return new SecondaryRecordRouteObjectBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of SecondaryRecordRouteObject, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see SecondaryRecordRouteObject
 *
 */
@Generated("mdsal-binding-generator")
public class SecondaryRecordRouteObjectBuilder {

    private List<SubobjectContainer> _subobjectContainer;


    Map<Class<? extends Augmentation<SecondaryRecordRouteObject>>, Augmentation<SecondaryRecordRouteObject>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public SecondaryRecordRouteObjectBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link RsvpTeObject}.
     *
     * @param arg RsvpTeObject from which the builder should be initialized
     */
    public SecondaryRecordRouteObjectBuilder(RsvpTeObject arg) {
    }
    

    /**
     * Construct a builder initialized with state from specified {@link SecondaryRecordRouteObject}.
     *
     * @param base SecondaryRecordRouteObject from which the builder should be initialized
     */
    public SecondaryRecordRouteObjectBuilder(SecondaryRecordRouteObject base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._subobjectContainer = base.getSubobjectContainer();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link RsvpTeObject}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof RsvpTeObject castArg) {
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[RsvpTeObject]");
    }

    private static final class LazyEmpty {
        static final @NonNull SecondaryRecordRouteObject INSTANCE = new SecondaryRecordRouteObjectBuilder().build();
    
        private LazyEmpty() {
            // Hidden on purpose
        }
    }
    
    /**
     * Get empty instance of SecondaryRecordRouteObject.
     *
     * @return An empty {@link SecondaryRecordRouteObject}
     */
    public static @NonNull SecondaryRecordRouteObject empty() {
        return LazyEmpty.INSTANCE;
    }

    /**
     * Return current value associated with the property corresponding to {@link SecondaryRecordRouteObject#getSubobjectContainer()}.
     *
     * @return current value
     */
    public List<SubobjectContainer> getSubobjectContainer() {
        return _subobjectContainer;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<SecondaryRecordRouteObject>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link SecondaryRecordRouteObject#getSubobjectContainer()} to the specified
     * value.
     *
     * @param values desired value
     * @return this builder
     */
    public SecondaryRecordRouteObjectBuilder setSubobjectContainer(final List<SubobjectContainer> values) {
        this._subobjectContainer = values;
        return this;
    }
    
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public SecondaryRecordRouteObjectBuilder addAugmentation(Augmentation<SecondaryRecordRouteObject> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public SecondaryRecordRouteObjectBuilder removeAugmentation(Class<? extends Augmentation<SecondaryRecordRouteObject>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link SecondaryRecordRouteObject} instance.
     *
     * @return A new {@link SecondaryRecordRouteObject} instance.
     */
    public @NonNull SecondaryRecordRouteObject build() {
        return new SecondaryRecordRouteObjectImpl(this);
    }

    private static final class SecondaryRecordRouteObjectImpl
        extends AbstractAugmentable<SecondaryRecordRouteObject>
        implements SecondaryRecordRouteObject {
    
        private final List<SubobjectContainer> _subobjectContainer;
    
        SecondaryRecordRouteObjectImpl(SecondaryRecordRouteObjectBuilder base) {
            super(base.augmentation);
            this._subobjectContainer = CodeHelpers.emptyToNull(base.getSubobjectContainer());
        }
    
        @Override
        public List<SubobjectContainer> getSubobjectContainer() {
            return _subobjectContainer;
        }
    
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = SecondaryRecordRouteObject.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return SecondaryRecordRouteObject.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return SecondaryRecordRouteObject.bindingToString(this);
        }
    }
}
