package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.tspec.object;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ieee754.rev130819.Float32;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.RsvpTeObject;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * SENDER TSPEC Object
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>rsvp</b>
 * <pre>
 * container tspec-object {
 *   uses rsvp-te-object;
 *   leaf token-bucket-rate {
 *     type ieee754:float32;
 *   }
 *   leaf token-bucket-size {
 *     type ieee754:float32;
 *   }
 *   leaf peak-data-rate {
 *     type ieee754:float32;
 *   }
 *   leaf minimum-policed-unit {
 *     type uint32;
 *   }
 *   leaf maximum-packet-size {
 *     type uint32;
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link TspecObjectBuilder}.
 * @see TspecObjectBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface TspecObject
    extends
    ChildOf<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TspecObject>,
    Augmentable<TspecObject>,
    RsvpTeObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("tspec-object");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.tspec.object.TspecObject> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.tspec.object.TspecObject.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.tspec.object.@NonNull TspecObject obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getMaximumPacketSize());
        result = prime * result + Objects.hashCode(obj.getMinimumPolicedUnit());
        result = prime * result + Objects.hashCode(obj.getPeakDataRate());
        result = prime * result + Objects.hashCode(obj.getTokenBucketRate());
        result = prime * result + Objects.hashCode(obj.getTokenBucketSize());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.tspec.object.@NonNull TspecObject thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.tspec.object.TspecObject.class, obj);
        return other != null
            && Objects.equals(thisObj.getMaximumPacketSize(), other.getMaximumPacketSize())
            && Objects.equals(thisObj.getMinimumPolicedUnit(), other.getMinimumPolicedUnit())
            && Objects.equals(thisObj.getPeakDataRate(), other.getPeakDataRate())
            && Objects.equals(thisObj.getTokenBucketRate(), other.getTokenBucketRate())
            && Objects.equals(thisObj.getTokenBucketSize(), other.getTokenBucketSize())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.tspec.object.@NonNull TspecObject obj) {
        final var helper = MoreObjects.toStringHelper("TspecObject");
        CodeHelpers.appendValue(helper, "maximumPacketSize", obj.getMaximumPacketSize());
        CodeHelpers.appendValue(helper, "minimumPolicedUnit", obj.getMinimumPolicedUnit());
        CodeHelpers.appendValue(helper, "peakDataRate", obj.getPeakDataRate());
        CodeHelpers.appendValue(helper, "tokenBucketRate", obj.getTokenBucketRate());
        CodeHelpers.appendValue(helper, "tokenBucketSize", obj.getTokenBucketSize());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return tokenBucketRate, or {@code null} if it is not present.
     *
     * @return {@code Float32} tokenBucketRate, or {@code null} if it is not present.
     *
     */
    Float32 getTokenBucketRate();
    
    /**
     * Return tokenBucketRate, guaranteed to be non-null.
     *
     * @return {@code Float32} tokenBucketRate, guaranteed to be non-null.
     * @throws NoSuchElementException if tokenBucketRate is not present
     *
     */
    default @NonNull Float32 requireTokenBucketRate() {
        return CodeHelpers.require(getTokenBucketRate(), "tokenbucketrate");
    }
    
    /**
     * Return tokenBucketSize, or {@code null} if it is not present.
     *
     * @return {@code Float32} tokenBucketSize, or {@code null} if it is not present.
     *
     */
    Float32 getTokenBucketSize();
    
    /**
     * Return tokenBucketSize, guaranteed to be non-null.
     *
     * @return {@code Float32} tokenBucketSize, guaranteed to be non-null.
     * @throws NoSuchElementException if tokenBucketSize is not present
     *
     */
    default @NonNull Float32 requireTokenBucketSize() {
        return CodeHelpers.require(getTokenBucketSize(), "tokenbucketsize");
    }
    
    /**
     * Return peakDataRate, or {@code null} if it is not present.
     *
     * @return {@code Float32} peakDataRate, or {@code null} if it is not present.
     *
     */
    Float32 getPeakDataRate();
    
    /**
     * Return peakDataRate, guaranteed to be non-null.
     *
     * @return {@code Float32} peakDataRate, guaranteed to be non-null.
     * @throws NoSuchElementException if peakDataRate is not present
     *
     */
    default @NonNull Float32 requirePeakDataRate() {
        return CodeHelpers.require(getPeakDataRate(), "peakdatarate");
    }
    
    /**
     * Return minimumPolicedUnit, or {@code null} if it is not present.
     *
     * @return {@code Uint32} minimumPolicedUnit, or {@code null} if it is not present.
     *
     */
    Uint32 getMinimumPolicedUnit();
    
    /**
     * Return minimumPolicedUnit, guaranteed to be non-null.
     *
     * @return {@code Uint32} minimumPolicedUnit, guaranteed to be non-null.
     * @throws NoSuchElementException if minimumPolicedUnit is not present
     *
     */
    default @NonNull Uint32 requireMinimumPolicedUnit() {
        return CodeHelpers.require(getMinimumPolicedUnit(), "minimumpolicedunit");
    }
    
    /**
     * Return maximumPacketSize, or {@code null} if it is not present.
     *
     * @return {@code Uint32} maximumPacketSize, or {@code null} if it is not present.
     *
     */
    Uint32 getMaximumPacketSize();
    
    /**
     * Return maximumPacketSize, guaranteed to be non-null.
     *
     * @return {@code Uint32} maximumPacketSize, guaranteed to be non-null.
     * @throws NoSuchElementException if maximumPacketSize is not present
     *
     */
    default @NonNull Uint32 requireMaximumPacketSize() {
        return CodeHelpers.require(getMaximumPacketSize(), "maximumpacketsize");
    }

}

