package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.tspec.object;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ieee754.rev130819.Float32;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.RsvpTeObject;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Class that builds {@link TspecObject} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     TspecObject createTspecObject(int fooXyzzy, int barBaz) {
 *         return new TspecObjectBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of TspecObject, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see TspecObject
 *
 */
@Generated("mdsal-binding-generator")
public class TspecObjectBuilder {

    private Uint32 _maximumPacketSize;
    private Uint32 _minimumPolicedUnit;
    private Float32 _peakDataRate;
    private Float32 _tokenBucketRate;
    private Float32 _tokenBucketSize;


    Map<Class<? extends Augmentation<TspecObject>>, Augmentation<TspecObject>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public TspecObjectBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link RsvpTeObject}.
     *
     * @param arg RsvpTeObject from which the builder should be initialized
     */
    public TspecObjectBuilder(RsvpTeObject arg) {
    }
    

    /**
     * Construct a builder initialized with state from specified {@link TspecObject}.
     *
     * @param base TspecObject from which the builder should be initialized
     */
    public TspecObjectBuilder(TspecObject base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._maximumPacketSize = base.getMaximumPacketSize();
        this._minimumPolicedUnit = base.getMinimumPolicedUnit();
        this._peakDataRate = base.getPeakDataRate();
        this._tokenBucketRate = base.getTokenBucketRate();
        this._tokenBucketSize = base.getTokenBucketSize();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link RsvpTeObject}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof RsvpTeObject castArg) {
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[RsvpTeObject]");
    }

    private static final class LazyEmpty {
        static final @NonNull TspecObject INSTANCE = new TspecObjectBuilder().build();
    
        private LazyEmpty() {
            // Hidden on purpose
        }
    }
    
    /**
     * Get empty instance of TspecObject.
     *
     * @return An empty {@link TspecObject}
     */
    public static @NonNull TspecObject empty() {
        return LazyEmpty.INSTANCE;
    }

    /**
     * Return current value associated with the property corresponding to {@link TspecObject#getMaximumPacketSize()}.
     *
     * @return current value
     */
    public Uint32 getMaximumPacketSize() {
        return _maximumPacketSize;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link TspecObject#getMinimumPolicedUnit()}.
     *
     * @return current value
     */
    public Uint32 getMinimumPolicedUnit() {
        return _minimumPolicedUnit;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link TspecObject#getPeakDataRate()}.
     *
     * @return current value
     */
    public Float32 getPeakDataRate() {
        return _peakDataRate;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link TspecObject#getTokenBucketRate()}.
     *
     * @return current value
     */
    public Float32 getTokenBucketRate() {
        return _tokenBucketRate;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link TspecObject#getTokenBucketSize()}.
     *
     * @return current value
     */
    public Float32 getTokenBucketSize() {
        return _tokenBucketSize;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<TspecObject>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link TspecObject#getMaximumPacketSize()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public TspecObjectBuilder setMaximumPacketSize(final Uint32 value) {
        this._maximumPacketSize = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link TspecObject#getMinimumPolicedUnit()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public TspecObjectBuilder setMinimumPolicedUnit(final Uint32 value) {
        this._minimumPolicedUnit = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link TspecObject#getPeakDataRate()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public TspecObjectBuilder setPeakDataRate(final Float32 value) {
        this._peakDataRate = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link TspecObject#getTokenBucketRate()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public TspecObjectBuilder setTokenBucketRate(final Float32 value) {
        this._tokenBucketRate = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link TspecObject#getTokenBucketSize()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public TspecObjectBuilder setTokenBucketSize(final Float32 value) {
        this._tokenBucketSize = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public TspecObjectBuilder addAugmentation(Augmentation<TspecObject> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public TspecObjectBuilder removeAugmentation(Class<? extends Augmentation<TspecObject>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link TspecObject} instance.
     *
     * @return A new {@link TspecObject} instance.
     */
    public @NonNull TspecObject build() {
        return new TspecObjectImpl(this);
    }

    private static final class TspecObjectImpl
        extends AbstractAugmentable<TspecObject>
        implements TspecObject {
    
        private final Uint32 _maximumPacketSize;
        private final Uint32 _minimumPolicedUnit;
        private final Float32 _peakDataRate;
        private final Float32 _tokenBucketRate;
        private final Float32 _tokenBucketSize;
    
        TspecObjectImpl(TspecObjectBuilder base) {
            super(base.augmentation);
            this._maximumPacketSize = base.getMaximumPacketSize();
            this._minimumPolicedUnit = base.getMinimumPolicedUnit();
            this._peakDataRate = base.getPeakDataRate();
            this._tokenBucketRate = base.getTokenBucketRate();
            this._tokenBucketSize = base.getTokenBucketSize();
        }
    
        @Override
        public Uint32 getMaximumPacketSize() {
            return _maximumPacketSize;
        }
        
        @Override
        public Uint32 getMinimumPolicedUnit() {
            return _minimumPolicedUnit;
        }
        
        @Override
        public Float32 getPeakDataRate() {
            return _peakDataRate;
        }
        
        @Override
        public Float32 getTokenBucketRate() {
            return _tokenBucketRate;
        }
        
        @Override
        public Float32 getTokenBucketSize() {
            return _tokenBucketSize;
        }
    
        
        
        
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = TspecObject.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return TspecObject.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return TspecObject.bindingToString(this);
        }
    }
}
