package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.svc.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>rsvp</b>
 * <pre>
 * grouping attribute-filters {
 *   leaf include-any {
 *     type attribute-filter;
 *   }
 *   leaf exclude-any {
 *     type attribute-filter;
 *   }
 *   leaf include-all {
 *     type attribute-filter;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface AttributeFilters
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("attribute-filters");

    @Override
    Class<? extends AttributeFilters> implementedInterface();
    
    /**
     * Return includeAny, or {@code null} if it is not present.
     *
     * @return {@code AttributeFilter} includeAny, or {@code null} if it is not present.
     *
     */
    AttributeFilter getIncludeAny();
    
    /**
     * Return includeAny, guaranteed to be non-null.
     *
     * @return {@code AttributeFilter} includeAny, guaranteed to be non-null.
     * @throws NoSuchElementException if includeAny is not present
     *
     */
    default @NonNull AttributeFilter requireIncludeAny() {
        return CodeHelpers.require(getIncludeAny(), "includeany");
    }
    
    /**
     * Return excludeAny, or {@code null} if it is not present.
     *
     * @return {@code AttributeFilter} excludeAny, or {@code null} if it is not present.
     *
     */
    AttributeFilter getExcludeAny();
    
    /**
     * Return excludeAny, guaranteed to be non-null.
     *
     * @return {@code AttributeFilter} excludeAny, guaranteed to be non-null.
     * @throws NoSuchElementException if excludeAny is not present
     *
     */
    default @NonNull AttributeFilter requireExcludeAny() {
        return CodeHelpers.require(getExcludeAny(), "excludeany");
    }
    
    /**
     * Return includeAll, or {@code null} if it is not present.
     *
     * @return {@code AttributeFilter} includeAll, or {@code null} if it is not present.
     *
     */
    AttributeFilter getIncludeAll();
    
    /**
     * Return includeAll, guaranteed to be non-null.
     *
     * @return {@code AttributeFilter} includeAll, guaranteed to be non-null.
     * @throws NoSuchElementException if includeAll is not present
     *
     */
    default @NonNull AttributeFilter requireIncludeAll() {
        return CodeHelpers.require(getIncludeAll(), "includeall");
    }

}

