package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820;
import java.lang.Class;
import java.lang.Override;
import java.util.List;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.attribute.flags.FlagContainer;
import org.opendaylight.yang.svc.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Attributes Flags
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>rsvp</b>
 * <pre>
 * grouping attribute-flags {
 *   list flag-container {
 *     leaf flags {
 *       type binary {
 *         length 4;
 *       }
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface AttributeFlags
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("attribute-flags");

    @Override
    Class<? extends AttributeFlags> implementedInterface();
    
    /**
     * Return flagContainer, or {@code null} if it is not present.
     *
     * @return {@code List<FlagContainer>} flagContainer, or {@code null} if it is not present.
     *
     */
    @Nullable List<FlagContainer> getFlagContainer();
    
    /**
     * Return flagContainer, or an empty list if it is not present.
     *
     * @return {@code List<FlagContainer>} flagContainer, or an empty list if it is not present.
     *
     */
    default @NonNull List<FlagContainer> nonnullFlagContainer() {
        return CodeHelpers.nonnull(getFlagContainer());
    }

}

