package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.svc.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.EnumTypeObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Subobject of an Exclude Route Object
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>rsvp</b>
 * <pre>
 * grouping exclude-route-subobjects {
 *   leaf mandatory {
 *     type boolean;
 *     default false;
 *   }
 *   leaf attribute {
 *     type enumeration {
 *       enum interface {
 *         value 0;
 *       }
 *       enum node {
 *         value 1;
 *       }
 *       enum srlg {
 *         value 2;
 *       }
 *     }
 *   }
 *   uses basic-explicit-route-subobjects;
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface ExcludeRouteSubobjects
    extends
    DataObject,
    BasicExplicitRouteSubobjects
{


    /**
     *
     * <p>
     * This class represents the following YANG schema fragment defined in module <b>rsvp</b>
     * <pre>
     * leaf attribute {
     *   type enumeration {
     *     enum interface {
     *       value 0;
     *     }
     *     enum node {
     *       value 1;
     *     }
     *     enum srlg {
     *       value 2;
     *     }
     *   }
     * }
     * </pre>
     *
     */
    @Generated("mdsal-binding-generator")
    public enum Attribute implements EnumTypeObject {
        Interface(0, "interface"),
        
        Node(1, "node"),
        
        Srlg(2, "srlg")
        ;
    
        private final @NonNull String name;
        private final int value;
    
        private Attribute(int value, @NonNull String name) {
            this.value = value;
            this.name = name;
        }
    
        @Override
        public @NonNull String getName() {
            return name;
        }
    
        @Override
        public int getIntValue() {
            return value;
        }
    
        /**
         * Return the enumeration member whose {@link #getName()} matches specified assigned name.
         *
         * @param name YANG assigned name
         * @return corresponding Attribute item, or {@code null} if no such item exists
         * @throws NullPointerException if {@code name} is null
         */
        public static @Nullable Attribute forName(String name) {
            return switch (name) {
                case "interface" -> Interface;
                case "node" -> Node;
                case "srlg" -> Srlg;
                default -> null;
            };
        }
    
        /**
         * Return the enumeration member whose {@link #getIntValue()} matches specified value.
         *
         * @param intValue integer value
         * @return corresponding Attribute item, or {@code null} if no such item exists
         */
        public static @Nullable Attribute forValue(int intValue) {
            return switch (intValue) {
                case 0 -> Interface;
                case 1 -> Node;
                case 2 -> Srlg;
                default -> null;
            };
        }
    
        /**
         * Return the enumeration member whose {@link #getName()} matches specified assigned name.
         *
         * @param name YANG assigned name
         * @return corresponding Attribute item
         * @throws NullPointerException if {@code name} is null
         * @throws IllegalArgumentException if {@code name} does not match any item
         */
        public static @NonNull Attribute ofName(String name) {
            return CodeHelpers.checkEnum(forName(name), name);
        }
    
        /**
         * Return the enumeration member whose {@link #getIntValue()} matches specified value.
         *
         * @param intValue integer value
         * @return corresponding Attribute item
         * @throws IllegalArgumentException if {@code intValue} does not match any item
         */
        public static @NonNull Attribute ofValue(int intValue) {
            return CodeHelpers.checkEnum(forValue(intValue), intValue);
        }
    }

    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("exclude-route-subobjects");

    @Override
    Class<? extends ExcludeRouteSubobjects> implementedInterface();
    
    /**
     * Return mandatory, or {@code null} if it is not present.
     *
     * @return {@code Boolean} mandatory, or {@code null} if it is not present.
     *
     */
    Boolean getMandatory();
    
    /**
     * Return mandatory, guaranteed to be non-null.
     *
     * @return {@code Boolean} mandatory, guaranteed to be non-null.
     * @throws NoSuchElementException if mandatory is not present
     *
     */
    default @NonNull Boolean requireMandatory() {
        return CodeHelpers.require(getMandatory(), "mandatory");
    }
    
    /**
     * Return attribute, or {@code null} if it is not present.
     *
     * @return {@code Attribute} attribute, or {@code null} if it is not present.
     *
     */
    Attribute getAttribute();
    
    /**
     * Return attribute, guaranteed to be non-null.
     *
     * @return {@code Attribute} attribute, guaranteed to be non-null.
     * @throws NoSuchElementException if attribute is not present
     *
     */
    default @NonNull Attribute requireAttribute() {
        return CodeHelpers.require(getAttribute(), "attribute");
    }

}

