package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.label.subobject.LabelType;
import org.opendaylight.yang.svc.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>rsvp</b>
 * <pre>
 * grouping label-subobject {
 *   uses c-subobject;
 *   leaf uni-directional {
 *     type boolean;
 *   }
 *   choice label-type {
 *     case type1-label-case {
 *       container type1-label {
 *         uses type1-label;
 *       }
 *     }
 *     case generalized-label-case {
 *       container generalized-label {
 *         uses generalized-label;
 *       }
 *     }
 *     case waveband-switching-label-case {
 *       container waveband-switching-label {
 *         uses waveband-switching-label;
 *       }
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface LabelSubobject
    extends
    DataObject,
    CSubobject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("label-subobject");

    @Override
    Class<? extends LabelSubobject> implementedInterface();
    
    /**
     * Return uniDirectional, or {@code null} if it is not present.
     *
     * @return {@code Boolean} uniDirectional, or {@code null} if it is not present.
     *
     */
    Boolean getUniDirectional();
    
    /**
     * Return uniDirectional, guaranteed to be non-null.
     *
     * @return {@code Boolean} uniDirectional, guaranteed to be non-null.
     * @throws NoSuchElementException if uniDirectional is not present
     *
     */
    default @NonNull Boolean requireUniDirectional() {
        return CodeHelpers.require(getUniDirectional(), "unidirectional");
    }
    
    /**
     * Return labelType, or {@code null} if it is not present.
     *
     * @return {@code LabelType} labelType, or {@code null} if it is not present.
     *
     */
    LabelType getLabelType();

}

