package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Override;
import java.lang.String;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.EnumTypeObject;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>rsvp</b>
 * <pre>
 * typedef link-flags {
 *   type enumeration {
 *     enum totally-unprotected {
 *       value 0;
 *     }
 *     enum extra-traffic {
 *       value 1;
 *     }
 *     enum unprotected {
 *       value 2;
 *     }
 *     enum shared {
 *       value 4;
 *     }
 *     enum dedicated-1to1 {
 *       value 8;
 *     }
 *     enum dedicated-1plus1 {
 *       value 10;
 *     }
 *     enum enhanced {
 *       value 20;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public enum LinkFlags implements EnumTypeObject {
    TotallyUnprotected(0, "totally-unprotected"),
    
    ExtraTraffic(1, "extra-traffic"),
    
    Unprotected(2, "unprotected"),
    
    Shared(4, "shared"),
    
    Dedicated1to1(8, "dedicated-1to1"),
    
    Dedicated1plus1(10, "dedicated-1plus1"),
    
    Enhanced(20, "enhanced")
    ;

    private final @NonNull String name;
    private final int value;

    private LinkFlags(int value, @NonNull String name) {
        this.value = value;
        this.name = name;
    }

    @Override
    public @NonNull String getName() {
        return name;
    }

    @Override
    public int getIntValue() {
        return value;
    }

    /**
     * Return the enumeration member whose {@link #getName()} matches specified assigned name.
     *
     * @param name YANG assigned name
     * @return corresponding LinkFlags item, or {@code null} if no such item exists
     * @throws NullPointerException if {@code name} is null
     */
    public static @Nullable LinkFlags forName(String name) {
        return switch (name) {
            case "totally-unprotected" -> TotallyUnprotected;
            case "extra-traffic" -> ExtraTraffic;
            case "unprotected" -> Unprotected;
            case "shared" -> Shared;
            case "dedicated-1to1" -> Dedicated1to1;
            case "dedicated-1plus1" -> Dedicated1plus1;
            case "enhanced" -> Enhanced;
            default -> null;
        };
    }

    /**
     * Return the enumeration member whose {@link #getIntValue()} matches specified value.
     *
     * @param intValue integer value
     * @return corresponding LinkFlags item, or {@code null} if no such item exists
     */
    public static @Nullable LinkFlags forValue(int intValue) {
        return switch (intValue) {
            case 0 -> TotallyUnprotected;
            case 1 -> ExtraTraffic;
            case 2 -> Unprotected;
            case 4 -> Shared;
            case 8 -> Dedicated1to1;
            case 10 -> Dedicated1plus1;
            case 20 -> Enhanced;
            default -> null;
        };
    }

    /**
     * Return the enumeration member whose {@link #getName()} matches specified assigned name.
     *
     * @param name YANG assigned name
     * @return corresponding LinkFlags item
     * @throws NullPointerException if {@code name} is null
     * @throws IllegalArgumentException if {@code name} does not match any item
     */
    public static @NonNull LinkFlags ofName(String name) {
        return CodeHelpers.checkEnum(forName(name), name);
    }

    /**
     * Return the enumeration member whose {@link #getIntValue()} matches specified value.
     *
     * @param intValue integer value
     * @return corresponding LinkFlags item
     * @throws IllegalArgumentException if {@code intValue} does not match any item
     */
    public static @NonNull LinkFlags ofValue(int intValue) {
        return CodeHelpers.checkEnum(forValue(intValue), intValue);
    }
}
