package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Override;
import java.lang.String;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.EnumTypeObject;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>rsvp</b>
 * <pre>
 * typedef lsp-flag {
 *   type enumeration {
 *     enum unprotected {
 *       value 0;
 *     }
 *     enum full-rerouting {
 *       value 1;
 *     }
 *     enum rerouting-without-extra-traffic {
 *       value 2;
 *     }
 *     enum protection-with-extra-traffic {
 *       value 4;
 *     }
 *     enum unidirectional-protection {
 *       value 8;
 *     }
 *     enum bidirectional-protection {
 *       value 10;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public enum LspFlag implements EnumTypeObject {
    Unprotected(0, "unprotected"),
    
    FullRerouting(1, "full-rerouting"),
    
    ReroutingWithoutExtraTraffic(2, "rerouting-without-extra-traffic"),
    
    ProtectionWithExtraTraffic(4, "protection-with-extra-traffic"),
    
    UnidirectionalProtection(8, "unidirectional-protection"),
    
    BidirectionalProtection(10, "bidirectional-protection")
    ;

    private final @NonNull String name;
    private final int value;

    private LspFlag(int value, @NonNull String name) {
        this.value = value;
        this.name = name;
    }

    @Override
    public @NonNull String getName() {
        return name;
    }

    @Override
    public int getIntValue() {
        return value;
    }

    /**
     * Return the enumeration member whose {@link #getName()} matches specified assigned name.
     *
     * @param name YANG assigned name
     * @return corresponding LspFlag item, or {@code null} if no such item exists
     * @throws NullPointerException if {@code name} is null
     */
    public static @Nullable LspFlag forName(String name) {
        return switch (name) {
            case "unprotected" -> Unprotected;
            case "full-rerouting" -> FullRerouting;
            case "rerouting-without-extra-traffic" -> ReroutingWithoutExtraTraffic;
            case "protection-with-extra-traffic" -> ProtectionWithExtraTraffic;
            case "unidirectional-protection" -> UnidirectionalProtection;
            case "bidirectional-protection" -> BidirectionalProtection;
            default -> null;
        };
    }

    /**
     * Return the enumeration member whose {@link #getIntValue()} matches specified value.
     *
     * @param intValue integer value
     * @return corresponding LspFlag item, or {@code null} if no such item exists
     */
    public static @Nullable LspFlag forValue(int intValue) {
        return switch (intValue) {
            case 0 -> Unprotected;
            case 1 -> FullRerouting;
            case 2 -> ReroutingWithoutExtraTraffic;
            case 4 -> ProtectionWithExtraTraffic;
            case 8 -> UnidirectionalProtection;
            case 10 -> BidirectionalProtection;
            default -> null;
        };
    }

    /**
     * Return the enumeration member whose {@link #getName()} matches specified assigned name.
     *
     * @param name YANG assigned name
     * @return corresponding LspFlag item
     * @throws NullPointerException if {@code name} is null
     * @throws IllegalArgumentException if {@code name} does not match any item
     */
    public static @NonNull LspFlag ofName(String name) {
        return CodeHelpers.checkEnum(forName(name), name);
    }

    /**
     * Return the enumeration member whose {@link #getIntValue()} matches specified value.
     *
     * @param intValue integer value
     * @return corresponding LspFlag item
     * @throws IllegalArgumentException if {@code intValue} does not match any item
     */
    public static @NonNull LspFlag ofValue(int intValue) {
        return CodeHelpers.checkEnum(forValue(intValue), intValue);
    }
}
