package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.ScalarTypeObject;
import org.opendaylight.yangtools.yang.common.Uint16;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>rsvp</b>
 * <pre>
 * typedef path-key {
 *   type uint16;
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public class PathKey
 implements ScalarTypeObject<Uint16>, Serializable {
    @java.io.Serial
    private static final long serialVersionUID = 1330045814905353022L;
    private final Uint16 _value;

    private static void check_valueRange(final int value) {
    }

    @ConstructorParameters("value")
    public PathKey(Uint16 _value) {
        if (_value != null) {
            check_valueRange(_value.intValue());
        }
        
        CodeHelpers.requireValue(_value);
    
        this._value = _value;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public PathKey(PathKey source) {
        this._value = source._value;
    }

    public static PathKey getDefaultInstance(final String defaultValue) {
        return new PathKey(Uint16.valueOf(defaultValue));
    }

    @Override
    public Uint16 getValue() {
        return _value;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_value);
    }

    @Override
    public final boolean equals(Object obj) {
        return this == obj || obj instanceof PathKey other
            && Objects.equals(_value, other._value);
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(PathKey.class);
        CodeHelpers.appendValue(helper, "value", _value);
        return helper.toString();
    }
}

