package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.svc.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>rsvp</b>
 * <pre>
 * grouping path-key-subobject {
 *   uses c-subobject;
 *   leaf pce-id {
 *     type pce-id;
 *   }
 *   leaf path-key {
 *     type path-key;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface PathKeySubobject
    extends
    DataObject,
    CSubobject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("path-key-subobject");

    @Override
    Class<? extends PathKeySubobject> implementedInterface();
    
    /**
     * Return pceId, or {@code null} if it is not present.
     *
     * @return {@code PceId} pceId, or {@code null} if it is not present.
     *
     */
    PceId getPceId();
    
    /**
     * Return pceId, guaranteed to be non-null.
     *
     * @return {@code PceId} pceId, guaranteed to be non-null.
     * @throws NoSuchElementException if pceId is not present
     *
     */
    default @NonNull PceId requirePceId() {
        return CodeHelpers.require(getPceId(), "pceid");
    }
    
    /**
     * Return pathKey, or {@code null} if it is not present.
     *
     * @return {@code PathKey} pathKey, or {@code null} if it is not present.
     *
     */
    PathKey getPathKey();
    
    /**
     * Return pathKey, guaranteed to be non-null.
     *
     * @return {@code PathKey} pathKey, guaranteed to be non-null.
     * @throws NoSuchElementException if pathKey is not present
     *
     */
    default @NonNull PathKey requirePathKey() {
        return CodeHelpers.require(getPathKey(), "pathkey");
    }

}

