package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Arrays;
import java.util.Base64;
import javax.annotation.processing.Generated;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.ScalarTypeObject;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>rsvp</b>
 * <pre>
 * typedef pce-id {
 *   type binary {
 *     length 4|16;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public class PceId
 implements ScalarTypeObject<byte[]>, Serializable {
    @java.io.Serial
    private static final long serialVersionUID = -3775655423512102136L;
    private final byte[] _value;

    private static void check_valueLength(final byte[] value) {
        final int length = value.length;
        if (length == 4) {
            return;
        }
        if (length == 16) {
            return;
        }
        CodeHelpers.throwInvalidLength("[[4..4], [16..16]]", value);
    }

    @ConstructorParameters("value")
    public PceId(byte[] _value) {
        if (_value != null) {
            check_valueLength(_value);
        }
        
        CodeHelpers.requireValue(_value);
    
        this._value = _value.clone();
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public PceId(PceId source) {
        this._value = source._value;
    }

    public static PceId getDefaultInstance(final String defaultValue) {
        return new PceId(Base64.getDecoder().decode(defaultValue));
    }

    @Override
    public byte[] getValue() {
        return _value.clone();
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_value);
    }

    @Override
    public final boolean equals(Object obj) {
        return this == obj || obj instanceof PceId other
            && Arrays.equals(_value, other._value);
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(PceId.class);
        CodeHelpers.appendValue(helper, "value", _value);
        return helper.toString();
    }
}

