package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.svc.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>rsvp</b>
 * <pre>
 * grouping priority {
 *   leaf hold-priority {
 *     type uint8;
 *     default 0;
 *   }
 *   leaf setup-priority {
 *     type uint8;
 *     default 0;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface Priority
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("priority");

    @Override
    Class<? extends Priority> implementedInterface();
    
    /**
     * Return holdPriority, or {@code null} if it is not present.
     *
     * @return {@code Uint8} holdPriority, or {@code null} if it is not present.
     *
     */
    Uint8 getHoldPriority();
    
    /**
     * Return holdPriority, guaranteed to be non-null.
     *
     * @return {@code Uint8} holdPriority, guaranteed to be non-null.
     * @throws NoSuchElementException if holdPriority is not present
     *
     */
    default @NonNull Uint8 requireHoldPriority() {
        return CodeHelpers.require(getHoldPriority(), "holdpriority");
    }
    
    /**
     * Return setupPriority, or {@code null} if it is not present.
     *
     * @return {@code Uint8} setupPriority, or {@code null} if it is not present.
     *
     */
    Uint8 getSetupPriority();
    
    /**
     * Return setupPriority, guaranteed to be non-null.
     *
     * @return {@code Uint8} setupPriority, guaranteed to be non-null.
     * @throws NoSuchElementException if setupPriority is not present
     *
     */
    default @NonNull Uint8 requireSetupPriority() {
        return CodeHelpers.require(getSetupPriority(), "setuppriority");
    }

}

