package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.yang.binding.DataRoot;

/**
 * This module contains the definition of types related to Resource Reservation 
 * Protocol (RSVP). Copyright (c)2013 Cisco Systems, Inc. All rights reserved. 
 * program and the accompanying materials are made available under the terms of 
 * Eclipse Public License v1.0 which accompanies this distribution, and is 
 * available at http://www.eclipse.org/legal/epl-v10.html
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>rsvp</b>
 * <pre>
 * module rsvp {
 *   yang-version 1;
 *   namespace urn:opendaylight:params:xml:ns:yang:rsvp;
 *   prefix rsvp;
 *   import iana {
 *     prefix iana;
 *     revision-date 2013-08-16;
 *   }
 *   import ietf-inet-types {
 *     prefix inet;
 *     revision-date 2013-07-15;
 *   }
 *   import ieee754 {
 *     prefix ieee754;
 *     revision-date 2013-08-19;
 *   }
 *   import network-concepts {
 *     prefix netc;
 *     revision-date 2013-11-25;
 *   }
 *   revision 2015-08-20 {
 *   }
 *   revision 2013-08-20 {
 *   }
 *   typedef attribute-filter {
 *     type uint32;
 *   }
 *   grouping attribute-filters {
 *     leaf include-any {
 *       type attribute-filter;
 *     }
 *     leaf exclude-any {
 *       type attribute-filter;
 *     }
 *     leaf include-all {
 *       type attribute-filter;
 *     }
 *   }
 *   grouping rsvp-te-object {
 *   }
 *   grouping priority {
 *     leaf hold-priority {
 *       type uint8;
 *       default 0;
 *     }
 *     leaf setup-priority {
 *       type uint8;
 *       default 0;
 *     }
 *   }
 *   grouping tunnel-attributes {
 *     uses priority;
 *     leaf local-protection-desired {
 *       type boolean;
 *       default false;
 *     }
 *     leaf label-recording-desired {
 *       type boolean;
 *       default false;
 *     }
 *     leaf se-style-desired {
 *       type boolean;
 *       default false;
 *     }
 *     leaf session-name {
 *       type string;
 *     }
 *     uses attribute-filters;
 *   }
 *   typedef lsp-id {
 *     type uint32;
 *   }
 *   typedef tunnel-id {
 *     type uint16;
 *   }
 *   typedef ipv4-extended-tunnel-id {
 *     type inet:ipv4-address-no-zone;
 *   }
 *   typedef ipv6-extended-tunnel-id {
 *     type inet:ipv6-address-no-zone;
 *   }
 *   typedef srlg-id {
 *     type uint32;
 *   }
 *   typedef lsp-flag {
 *     type enumeration {
 *       enum unprotected {
 *         value 0;
 *       }
 *       enum full-rerouting {
 *         value 1;
 *       }
 *       enum rerouting-without-extra-traffic {
 *         value 2;
 *       }
 *       enum protection-with-extra-traffic {
 *         value 4;
 *       }
 *       enum unidirectional-protection {
 *         value 8;
 *       }
 *       enum bidirectional-protection {
 *         value 10;
 *       }
 *     }
 *   }
 *   typedef link-flags {
 *     type enumeration {
 *       enum totally-unprotected {
 *         value 0;
 *       }
 *       enum extra-traffic {
 *         value 1;
 *       }
 *       enum unprotected {
 *         value 2;
 *       }
 *       enum shared {
 *         value 4;
 *       }
 *       enum dedicated-1to1 {
 *         value 8;
 *       }
 *       enum dedicated-1plus1 {
 *         value 10;
 *       }
 *       enum enhanced {
 *         value 20;
 *       }
 *     }
 *   }
 *   grouping error-spec {
 *     leaf node {
 *       type inet:ip-address-no-zone;
 *     }
 *     leaf flags {
 *       type bits {
 *         bit in-place {
 *           position 7;
 *         }
 *         bit not-guilty {
 *           position 6;
 *         }
 *       }
 *     }
 *     leaf code {
 *       type uint8;
 *     }
 *     leaf value {
 *       type uint16;
 *     }
 *   }
 *   grouping user-error-spec {
 *     leaf enterprise {
 *       type iana:enterprise-number;
 *     }
 *     leaf sub-org {
 *       type uint8;
 *       default 0;
 *     }
 *     leaf value {
 *       type uint16;
 *     }
 *     leaf description {
 *       type string;
 *       default "";
 *     }
 *     container subobjects;
 *   }
 *   grouping c-label;
 *   grouping type1-label {
 *     uses c-label;
 *     leaf type1-label {
 *       type uint32;
 *     }
 *   }
 *   grouping generalized-label {
 *     uses c-label;
 *     leaf generalized-label {
 *       type binary;
 *     }
 *   }
 *   grouping waveband-switching-label {
 *     uses c-label;
 *     leaf end-label {
 *       type uint32;
 *     }
 *     leaf start-label {
 *       type uint32;
 *     }
 *     leaf waveband-id {
 *       type uint32;
 *     }
 *   }
 *   grouping label-set {
 *     leaf action {
 *       type enumeration {
 *         enum inclusive-list {
 *           value 0;
 *         }
 *         enum exclusive-list {
 *           value 1;
 *         }
 *         enum inclusive-range {
 *           value 2;
 *         }
 *         enum exclusive-range {
 *           value 3;
 *         }
 *       }
 *     }
 *     container label-type;
 *     list subchannels;
 *   }
 *   grouping c-subobject;
 *   grouping ip-prefix-subobject {
 *     uses c-subobject;
 *     leaf ip-prefix {
 *       type inet:ip-prefix;
 *     }
 *   }
 *   grouping as-number-subobject {
 *     uses c-subobject;
 *     leaf as-number {
 *       type inet:as-number;
 *     }
 *   }
 *   grouping label-subobject {
 *     uses c-subobject;
 *     leaf uni-directional {
 *       type boolean;
 *     }
 *     choice label-type {
 *       case type1-label-case {
 *         container type1-label {
 *           uses type1-label;
 *         }
 *       }
 *       case generalized-label-case {
 *         container generalized-label {
 *           uses generalized-label;
 *         }
 *       }
 *       case waveband-switching-label-case {
 *         container waveband-switching-label {
 *           uses waveband-switching-label;
 *         }
 *       }
 *     }
 *   }
 *   grouping unnumbered-subobject {
 *     uses c-subobject;
 *     leaf router-id {
 *       type uint32;
 *     }
 *     leaf interface-id {
 *       type uint32;
 *     }
 *   }
 *   grouping srlg-subobject {
 *     uses c-subobject;
 *     leaf srlg-id {
 *       type srlg-id;
 *     }
 *   }
 *   typedef path-key {
 *     type uint16;
 *   }
 *   typedef pce-id {
 *     type binary {
 *       length 4|16;
 *     }
 *   }
 *   grouping path-key-subobject {
 *     uses c-subobject;
 *     leaf pce-id {
 *       type pce-id;
 *     }
 *     leaf path-key {
 *       type path-key;
 *     }
 *   }
 *   grouping protection-subobject {
 *     container protection-subobject {
 *       leaf secondary {
 *         type boolean;
 *         default false;
 *       }
 *       leaf protecting {
 *         type boolean;
 *         default false;
 *       }
 *       leaf notification {
 *         type boolean;
 *         default false;
 *       }
 *       leaf operational {
 *         type boolean;
 *         default false;
 *       }
 *       leaf lsp-flag {
 *         type lsp-flag;
 *       }
 *       leaf link-flags {
 *         type link-flags;
 *       }
 *       leaf in-place {
 *         type boolean;
 *         default false;
 *       }
 *       leaf required {
 *         type boolean;
 *         default false;
 *       }
 *       leaf seg-flag {
 *         type lsp-flag;
 *       }
 *     }
 *   }
 *   grouping record-route-subobjects {
 *     leaf protection-available {
 *       type boolean;
 *       default false;
 *     }
 *     leaf protection-in-use {
 *       type boolean;
 *       default false;
 *     }
 *     choice subobject-type {
 *       case ip-prefix-case {
 *         container ip-prefix {
 *           uses ip-prefix-subobject;
 *         }
 *       }
 *       case label-case {
 *         container label {
 *           uses label-subobject;
 *           leaf global {
 *             type boolean;
 *             default false;
 *           }
 *         }
 *       }
 *       case unnumbered-case {
 *         container unnumbered {
 *           uses unnumbered-subobject;
 *         }
 *       }
 *       case path-key-case {
 *         container path-key {
 *           uses path-key-subobject;
 *         }
 *       }
 *     }
 *   }
 *   grouping basic-explicit-route-subobjects {
 *     choice subobject-type {
 *       case as-number-case {
 *         container as-number {
 *           uses as-number-subobject;
 *         }
 *       }
 *       case ip-prefix-case {
 *         container ip-prefix {
 *           uses ip-prefix-subobject;
 *         }
 *       }
 *       case label-case {
 *         container label {
 *           uses label-subobject;
 *         }
 *       }
 *       case srlg-case {
 *         container srlg {
 *           uses srlg-subobject;
 *         }
 *       }
 *       case unnumbered-case {
 *         container unnumbered {
 *           uses unnumbered-subobject;
 *         }
 *       }
 *     }
 *   }
 *   grouping exclude-route-object {
 *     container exclude-route-object {
 *       uses rsvp-te-object;
 *       list subobject-container {
 *         uses exclude-route-subobjects;
 *         ordered-by user;
 *       }
 *     }
 *   }
 *   grouping record-route-subobjects-list {
 *     list subobject-container {
 *       uses record-route-subobjects;
 *       ordered-by user;
 *     }
 *   }
 *   grouping explicit-route-subobjects-list {
 *     list subobject-container {
 *       leaf loose {
 *         type boolean;
 *       }
 *       uses explicit-route-subobjects;
 *       ordered-by user;
 *     }
 *   }
 *   grouping record-route-object {
 *     container record-route-object {
 *       uses rsvp-te-object;
 *       uses record-route-subobjects-list;
 *     }
 *   }
 *   grouping explicit-route-object {
 *     container explicit-route-object {
 *       uses rsvp-te-object;
 *       uses explicit-route-subobjects-list;
 *     }
 *   }
 *   grouping secondary-explicit-route-object {
 *     container secondary-explicit-route-object {
 *       uses rsvp-te-object;
 *       list subobject-container {
 *         leaf loose {
 *           type boolean;
 *         }
 *         uses secondary-explicit-route-subobjects;
 *         ordered-by user;
 *       }
 *     }
 *   }
 *   grouping secondary-explicit-route-subobjects {
 *     uses explicit-route-subobjects {
 *       augment subobject-type {
 *         case basic-protection-case {
 *           container basic-protection {
 *             uses protection-subobject;
 *           }
 *         }
 *         case dynamic-control-protection-case {
 *           container dynamic-control-protection {
 *             uses protection-subobject;
 *           }
 *         }
 *       }
 *     }
 *   }
 *   grouping secondary-record-route-object {
 *     container secondary-record-route-object {
 *       uses rsvp-te-object;
 *       list subobject-container {
 *         uses secondary-record-route-subobjects;
 *         ordered-by user;
 *       }
 *     }
 *   }
 *   grouping secondary-record-route-subobjects {
 *     uses record-route-subobjects {
 *       augment subobject-type {
 *         case basic-protection-case {
 *           container basic-protection {
 *             uses protection-subobject;
 *           }
 *         }
 *         case dynamic-control-protection-case {
 *           container dynamic-control-protection {
 *             uses protection-subobject;
 *           }
 *         }
 *       }
 *     }
 *   }
 *   grouping exclude-route-subobjects {
 *     leaf mandatory {
 *       type boolean;
 *       default false;
 *     }
 *     leaf attribute {
 *       type enumeration {
 *         enum interface {
 *           value 0;
 *         }
 *         enum node {
 *           value 1;
 *         }
 *         enum srlg {
 *           value 2;
 *         }
 *       }
 *     }
 *     uses basic-explicit-route-subobjects;
 *   }
 *   grouping explicit-route-subobjects {
 *     uses basic-explicit-route-subobjects {
 *       augment subobject-type {
 *         case exrs-case {
 *           container exrs {
 *             list exrs {
 *               uses exclude-route-subobjects;
 *             }
 *           }
 *         }
 *         case path-key-case {
 *           container path-key {
 *             uses path-key-subobject;
 *           }
 *         }
 *       }
 *     }
 *   }
 *   grouping tspec-object {
 *     container tspec-object {
 *       uses rsvp-te-object;
 *       leaf token-bucket-rate {
 *         type ieee754:float32;
 *       }
 *       leaf token-bucket-size {
 *         type ieee754:float32;
 *       }
 *       leaf peak-data-rate {
 *         type ieee754:float32;
 *       }
 *       leaf minimum-policed-unit {
 *         type uint32;
 *       }
 *       leaf maximum-packet-size {
 *         type uint32;
 *       }
 *     }
 *   }
 *   typedef service-number {
 *     type enumeration {
 *       enum guaranteed {
 *         value 2;
 *       }
 *       enum controlled-load {
 *         value 5;
 *       }
 *     }
 *   }
 *   grouping flow-spec-object {
 *     container flow-spec-object {
 *       uses rsvp-te-object;
 *       leaf service-header {
 *         type service-number;
 *       }
 *       uses tspec-object;
 *       leaf rate {
 *         type ieee754:float32;
 *       }
 *       leaf slack-term {
 *         type uint32;
 *       }
 *     }
 *   }
 *   typedef association-type {
 *     type enumeration {
 *       enum reserved {
 *         value 0;
 *       }
 *       enum recovery {
 *         value 1;
 *       }
 *     }
 *   }
 *   grouping association-object {
 *     container association-object {
 *       uses rsvp-te-object;
 *       leaf association-type {
 *         type association-type;
 *       }
 *       leaf association-id {
 *         type uint16;
 *       }
 *       leaf ip-address {
 *         type inet:ip-address-no-zone;
 *       }
 *     }
 *   }
 *   grouping admin-status-object {
 *     container admin-status-object {
 *       uses rsvp-te-object;
 *       leaf reflect {
 *         type boolean;
 *         default false;
 *       }
 *       leaf testing {
 *         type boolean;
 *         default false;
 *       }
 *       leaf administratively-down {
 *         type boolean;
 *         default false;
 *       }
 *       leaf deletion-in-progress {
 *         type boolean;
 *         default false;
 *       }
 *     }
 *   }
 *   grouping primary-path-route-object {
 *     container primary-path-route-object {
 *       uses rsvp-te-object;
 *       uses explicit-route-subobjects-list;
 *     }
 *   }
 *   grouping detour-object {
 *     choice detour-object {
 *       case ipv4-detour-object {
 *         uses rsvp-te-object;
 *         list plr {
 *           leaf plr-id {
 *             type inet:ipv4-address-no-zone;
 *           }
 *           leaf avoid-node {
 *             type inet:ipv4-address-no-zone;
 *           }
 *         }
 *       }
 *       case ipv6-detour-object {
 *         uses rsvp-te-object;
 *         list plr-id {
 *           leaf plr-id {
 *             type inet:ipv6-address-no-zone;
 *           }
 *         }
 *         list avoid-node {
 *           leaf avoid-node {
 *             type inet:ipv6-address-no-zone;
 *           }
 *         }
 *       }
 *     }
 *   }
 *   typedef fast-reroute-flags {
 *     type enumeration {
 *       enum one-to-one-backup-desired {
 *         value 1;
 *       }
 *       enum facility-backup-desired {
 *         value 2;
 *       }
 *     }
 *   }
 *   grouping common-fast-reroute-object {
 *     uses rsvp-te-object;
 *     uses priority;
 *     uses attribute-filters;
 *     leaf hop-limit {
 *       type uint8;
 *       default 0;
 *     }
 *     leaf flags {
 *       type fast-reroute-flags;
 *     }
 *     leaf bandwidth {
 *       type netc:bandwidth;
 *     }
 *   }
 *   grouping fast-reroute-object {
 *     choice fast-reroute-object {
 *       case basic-fast-reroute-object-case {
 *         container basic-fast-reroute-object {
 *           uses common-fast-reroute-object;
 *         }
 *       }
 *       case legacy-fast-reroute-object-case {
 *         container legacy-fast-reroute-object {
 *           uses common-fast-reroute-object;
 *         }
 *       }
 *     }
 *   }
 *   grouping session-attribute-object {
 *     choice session-attribute-object {
 *       case basic-session-attribute-object-case {
 *         container basic-session-attribute-object {
 *           uses rsvp-te-object;
 *           uses tunnel-attributes;
 *         }
 *       }
 *       case session-attribute-object-with-resources-affinities-case {
 *         container session-attribute-object-with-resources-affinities {
 *           uses rsvp-te-object;
 *           uses tunnel-attributes;
 *         }
 *       }
 *     }
 *   }
 *   grouping bandwidth-object {
 *     choice bandwidth-object {
 *       case basic-bandwidth-object-case {
 *         container basic-bandwidth-object {
 *           uses rsvp-te-object;
 *           leaf bandwidth {
 *             type netc:bandwidth;
 *           }
 *         }
 *       }
 *       case reoptimization-bandwidth-object-case {
 *         container reoptimization-bandwidth-object {
 *           uses rsvp-te-object;
 *           leaf bandwidth {
 *             type netc:bandwidth;
 *           }
 *         }
 *       }
 *     }
 *   }
 *   grouping metric-object {
 *     container metric-object {
 *       uses rsvp-te-object;
 *       leaf metric-type {
 *         type uint8;
 *       }
 *       leaf bound {
 *         type boolean;
 *         default false;
 *       }
 *       leaf computed {
 *         type boolean;
 *         default false;
 *       }
 *       leaf value {
 *         type ieee754:float32;
 *       }
 *     }
 *   }
 *   grouping protection-object {
 *     choice protection-object {
 *       case basic-protection-object-case {
 *         container basic-protection-object {
 *           uses rsvp-te-object;
 *           uses protection-subobject;
 *         }
 *       }
 *       case dynamic-control-protection-object-case {
 *         container dynamic-control-protection-object {
 *           uses rsvp-te-object;
 *           uses protection-subobject;
 *         }
 *       }
 *     }
 *   }
 *   grouping lsp-attributes-object {
 *     container lsp-attributes-object {
 *       uses rsvp-te-object;
 *       list subobject-container {
 *         uses lsp-att-subobject;
 *       }
 *     }
 *   }
 *   grouping lsp-required-attributes-object {
 *     container lsp-required-attributes-object {
 *       uses rsvp-te-object;
 *       uses lsp-attributes-object;
 *     }
 *   }
 *   grouping attribute-flags {
 *     list flag-container {
 *       leaf flags {
 *         type binary {
 *           length 4;
 *         }
 *       }
 *     }
 *   }
 *   grouping lsp-att-subobject {
 *     choice lsp-subobject {
 *       case flags-tlv {
 *         uses attribute-flags;
 *       }
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface RsvpData
    extends
    DataRoot
{





}

