package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Override;
import java.lang.String;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.EnumTypeObject;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>rsvp</b>
 * <pre>
 * typedef service-number {
 *   type enumeration {
 *     enum guaranteed {
 *       value 2;
 *     }
 *     enum controlled-load {
 *       value 5;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public enum ServiceNumber implements EnumTypeObject {
    Guaranteed(2, "guaranteed"),
    
    ControlledLoad(5, "controlled-load")
    ;

    private final @NonNull String name;
    private final int value;

    private ServiceNumber(int value, @NonNull String name) {
        this.value = value;
        this.name = name;
    }

    @Override
    public @NonNull String getName() {
        return name;
    }

    @Override
    public int getIntValue() {
        return value;
    }

    /**
     * Return the enumeration member whose {@link #getName()} matches specified assigned name.
     *
     * @param name YANG assigned name
     * @return corresponding ServiceNumber item, or {@code null} if no such item exists
     * @throws NullPointerException if {@code name} is null
     */
    public static @Nullable ServiceNumber forName(String name) {
        return switch (name) {
            case "guaranteed" -> Guaranteed;
            case "controlled-load" -> ControlledLoad;
            default -> null;
        };
    }

    /**
     * Return the enumeration member whose {@link #getIntValue()} matches specified value.
     *
     * @param intValue integer value
     * @return corresponding ServiceNumber item, or {@code null} if no such item exists
     */
    public static @Nullable ServiceNumber forValue(int intValue) {
        return switch (intValue) {
            case 2 -> Guaranteed;
            case 5 -> ControlledLoad;
            default -> null;
        };
    }

    /**
     * Return the enumeration member whose {@link #getName()} matches specified assigned name.
     *
     * @param name YANG assigned name
     * @return corresponding ServiceNumber item
     * @throws NullPointerException if {@code name} is null
     * @throws IllegalArgumentException if {@code name} does not match any item
     */
    public static @NonNull ServiceNumber ofName(String name) {
        return CodeHelpers.checkEnum(forName(name), name);
    }

    /**
     * Return the enumeration member whose {@link #getIntValue()} matches specified value.
     *
     * @param intValue integer value
     * @return corresponding ServiceNumber item
     * @throws IllegalArgumentException if {@code intValue} does not match any item
     */
    public static @NonNull ServiceNumber ofValue(int intValue) {
        return CodeHelpers.checkEnum(forValue(intValue), intValue);
    }
}
