package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.bandwidth.object.bandwidth.object;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.bandwidth.object.bandwidth.object.reoptimization.bandwidth.object._case.ReoptimizationBandwidthObject;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

/**
 * Class that builds {@link ReoptimizationBandwidthObjectCase} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     ReoptimizationBandwidthObjectCase createReoptimizationBandwidthObjectCase(int fooXyzzy, int barBaz) {
 *         return new ReoptimizationBandwidthObjectCaseBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of ReoptimizationBandwidthObjectCase, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see ReoptimizationBandwidthObjectCase
 *
 */
@Generated("mdsal-binding-generator")
public class ReoptimizationBandwidthObjectCaseBuilder {

    private ReoptimizationBandwidthObject _reoptimizationBandwidthObject;


    Map<Class<? extends Augmentation<ReoptimizationBandwidthObjectCase>>, Augmentation<ReoptimizationBandwidthObjectCase>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public ReoptimizationBandwidthObjectCaseBuilder() {
        // No-op
    }

    
    

    /**
     * Construct a builder initialized with state from specified {@link ReoptimizationBandwidthObjectCase}.
     *
     * @param base ReoptimizationBandwidthObjectCase from which the builder should be initialized
     */
    public ReoptimizationBandwidthObjectCaseBuilder(ReoptimizationBandwidthObjectCase base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._reoptimizationBandwidthObject = base.getReoptimizationBandwidthObject();
    }



    /**
     * Return current value associated with the property corresponding to {@link ReoptimizationBandwidthObjectCase#getReoptimizationBandwidthObject()}.
     *
     * @return current value
     */
    public ReoptimizationBandwidthObject getReoptimizationBandwidthObject() {
        return _reoptimizationBandwidthObject;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<ReoptimizationBandwidthObjectCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link ReoptimizationBandwidthObjectCase#getReoptimizationBandwidthObject()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ReoptimizationBandwidthObjectCaseBuilder setReoptimizationBandwidthObject(final ReoptimizationBandwidthObject value) {
        this._reoptimizationBandwidthObject = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public ReoptimizationBandwidthObjectCaseBuilder addAugmentation(Augmentation<ReoptimizationBandwidthObjectCase> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public ReoptimizationBandwidthObjectCaseBuilder removeAugmentation(Class<? extends Augmentation<ReoptimizationBandwidthObjectCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link ReoptimizationBandwidthObjectCase} instance.
     *
     * @return A new {@link ReoptimizationBandwidthObjectCase} instance.
     */
    public @NonNull ReoptimizationBandwidthObjectCase build() {
        return new ReoptimizationBandwidthObjectCaseImpl(this);
    }

    private static final class ReoptimizationBandwidthObjectCaseImpl
        extends AbstractAugmentable<ReoptimizationBandwidthObjectCase>
        implements ReoptimizationBandwidthObjectCase {
    
        private final ReoptimizationBandwidthObject _reoptimizationBandwidthObject;
    
        ReoptimizationBandwidthObjectCaseImpl(ReoptimizationBandwidthObjectCaseBuilder base) {
            super(base.augmentation);
            this._reoptimizationBandwidthObject = base.getReoptimizationBandwidthObject();
        }
    
        @Override
        public ReoptimizationBandwidthObject getReoptimizationBandwidthObject() {
            return _reoptimizationBandwidthObject;
        }
    
        @Override
        public ReoptimizationBandwidthObject nonnullReoptimizationBandwidthObject() {
            return Objects.requireNonNullElse(getReoptimizationBandwidthObject(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.bandwidth.object.bandwidth.object.reoptimization.bandwidth.object._case.ReoptimizationBandwidthObjectBuilder.empty());
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = ReoptimizationBandwidthObjectCase.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return ReoptimizationBandwidthObjectCase.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return ReoptimizationBandwidthObjectCase.bindingToString(this);
        }
    }
}
