package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.bandwidth.object.bandwidth.object.basic.bandwidth.object._case;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.Bandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.RsvpTeObject;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link BasicBandwidthObject} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     BasicBandwidthObject createBasicBandwidthObject(int fooXyzzy, int barBaz) {
 *         return new BasicBandwidthObjectBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of BasicBandwidthObject, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see BasicBandwidthObject
 *
 */
@Generated("mdsal-binding-generator")
public class BasicBandwidthObjectBuilder {

    private Bandwidth _bandwidth;


    Map<Class<? extends Augmentation<BasicBandwidthObject>>, Augmentation<BasicBandwidthObject>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public BasicBandwidthObjectBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link RsvpTeObject}.
     *
     * @param arg RsvpTeObject from which the builder should be initialized
     */
    public BasicBandwidthObjectBuilder(RsvpTeObject arg) {
    }
    

    /**
     * Construct a builder initialized with state from specified {@link BasicBandwidthObject}.
     *
     * @param base BasicBandwidthObject from which the builder should be initialized
     */
    public BasicBandwidthObjectBuilder(BasicBandwidthObject base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._bandwidth = base.getBandwidth();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link RsvpTeObject}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof RsvpTeObject castArg) {
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[RsvpTeObject]");
    }

    private static final class LazyEmpty {
        static final @NonNull BasicBandwidthObject INSTANCE = new BasicBandwidthObjectBuilder().build();
    
        private LazyEmpty() {
            // Hidden on purpose
        }
    }
    
    /**
     * Get empty instance of BasicBandwidthObject.
     *
     * @return An empty {@link BasicBandwidthObject}
     */
    public static @NonNull BasicBandwidthObject empty() {
        return LazyEmpty.INSTANCE;
    }

    /**
     * Return current value associated with the property corresponding to {@link BasicBandwidthObject#getBandwidth()}.
     *
     * @return current value
     */
    public Bandwidth getBandwidth() {
        return _bandwidth;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<BasicBandwidthObject>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link BasicBandwidthObject#getBandwidth()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public BasicBandwidthObjectBuilder setBandwidth(final Bandwidth value) {
        this._bandwidth = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public BasicBandwidthObjectBuilder addAugmentation(Augmentation<BasicBandwidthObject> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public BasicBandwidthObjectBuilder removeAugmentation(Class<? extends Augmentation<BasicBandwidthObject>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link BasicBandwidthObject} instance.
     *
     * @return A new {@link BasicBandwidthObject} instance.
     */
    public @NonNull BasicBandwidthObject build() {
        return new BasicBandwidthObjectImpl(this);
    }

    private static final class BasicBandwidthObjectImpl
        extends AbstractAugmentable<BasicBandwidthObject>
        implements BasicBandwidthObject {
    
        private final Bandwidth _bandwidth;
    
        BasicBandwidthObjectImpl(BasicBandwidthObjectBuilder base) {
            super(base.augmentation);
            this._bandwidth = base.getBandwidth();
        }
    
        @Override
        public Bandwidth getBandwidth() {
            return _bandwidth;
        }
    
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = BasicBandwidthObject.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return BasicBandwidthObject.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return BasicBandwidthObject.bindingToString(this);
        }
    }
}
