package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.srlg._case;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.CSubobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.SrlgId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.SrlgSubobject;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link Srlg} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Srlg createSrlg(int fooXyzzy, int barBaz) {
 *         return new SrlgBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Srlg, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Srlg
 *
 */
@Generated("mdsal-binding-generator")
public class SrlgBuilder {

    private SrlgId _srlgId;


    Map<Class<? extends Augmentation<Srlg>>, Augmentation<Srlg>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public SrlgBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link SrlgSubobject}.
     *
     * @param arg SrlgSubobject from which the builder should be initialized
     */
    public SrlgBuilder(SrlgSubobject arg) {
        this._srlgId = arg.getSrlgId();
    }
    
    /**
     * Construct a new builder initialized from specified {@link CSubobject}.
     *
     * @param arg CSubobject from which the builder should be initialized
     */
    public SrlgBuilder(CSubobject arg) {
    }
    

    /**
     * Construct a builder initialized with state from specified {@link Srlg}.
     *
     * @param base Srlg from which the builder should be initialized
     */
    public SrlgBuilder(Srlg base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._srlgId = base.getSrlgId();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link CSubobject}</li>
     *   <li>{@link SrlgSubobject}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof CSubobject castArg) {
            isValidArg = true;
        }
        if (arg instanceof SrlgSubobject castArg) {
            this._srlgId = castArg.getSrlgId();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[CSubobject, SrlgSubobject]");
    }

    private static final class LazyEmpty {
        static final @NonNull Srlg INSTANCE = new SrlgBuilder().build();
    
        private LazyEmpty() {
            // Hidden on purpose
        }
    }
    
    /**
     * Get empty instance of Srlg.
     *
     * @return An empty {@link Srlg}
     */
    public static @NonNull Srlg empty() {
        return LazyEmpty.INSTANCE;
    }

    /**
     * Return current value associated with the property corresponding to {@link Srlg#getSrlgId()}.
     *
     * @return current value
     */
    public SrlgId getSrlgId() {
        return _srlgId;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Srlg>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link Srlg#getSrlgId()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SrlgBuilder setSrlgId(final SrlgId value) {
        this._srlgId = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public SrlgBuilder addAugmentation(Augmentation<Srlg> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public SrlgBuilder removeAugmentation(Class<? extends Augmentation<Srlg>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Srlg} instance.
     *
     * @return A new {@link Srlg} instance.
     */
    public @NonNull Srlg build() {
        return new SrlgImpl(this);
    }

    private static final class SrlgImpl
        extends AbstractAugmentable<Srlg>
        implements Srlg {
    
        private final SrlgId _srlgId;
    
        SrlgImpl(SrlgBuilder base) {
            super(base.augmentation);
            this._srlgId = base.getSrlgId();
        }
    
        @Override
        public SrlgId getSrlgId() {
            return _srlgId;
        }
    
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Srlg.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Srlg.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Srlg.bindingToString(this);
        }
    }
}
