package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.detour.object.detour.object.ipv6.detour.object;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6AddressNoZone;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

/**
 * Class that builds {@link AvoidNode} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     AvoidNode createAvoidNode(int fooXyzzy, int barBaz) {
 *         return new AvoidNodeBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of AvoidNode, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see AvoidNode
 *
 */
@Generated("mdsal-binding-generator")
public class AvoidNodeBuilder {

    private Ipv6AddressNoZone _avoidNode;


    Map<Class<? extends Augmentation<AvoidNode>>, Augmentation<AvoidNode>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public AvoidNodeBuilder() {
        // No-op
    }

    

    /**
     * Construct a builder initialized with state from specified {@link AvoidNode}.
     *
     * @param base AvoidNode from which the builder should be initialized
     */
    public AvoidNodeBuilder(AvoidNode base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._avoidNode = base.getAvoidNode();
    }



    /**
     * Return current value associated with the property corresponding to {@link AvoidNode#getAvoidNode()}.
     *
     * @return current value
     */
    public Ipv6AddressNoZone getAvoidNode() {
        return _avoidNode;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<AvoidNode>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link AvoidNode#getAvoidNode()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public AvoidNodeBuilder setAvoidNode(final Ipv6AddressNoZone value) {
        this._avoidNode = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public AvoidNodeBuilder addAugmentation(Augmentation<AvoidNode> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public AvoidNodeBuilder removeAugmentation(Class<? extends Augmentation<AvoidNode>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link AvoidNode} instance.
     *
     * @return A new {@link AvoidNode} instance.
     */
    public @NonNull AvoidNode build() {
        return new AvoidNodeImpl(this);
    }

    private static final class AvoidNodeImpl
        extends AbstractAugmentable<AvoidNode>
        implements AvoidNode {
    
        private final Ipv6AddressNoZone _avoidNode;
    
        AvoidNodeImpl(AvoidNodeBuilder base) {
            super(base.augmentation);
            this._avoidNode = base.getAvoidNode();
        }
    
        @Override
        public Ipv6AddressNoZone getAvoidNode() {
            return _avoidNode;
        }
    
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = AvoidNode.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return AvoidNode.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return AvoidNode.bindingToString(this);
        }
    }
}
