package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.fast.reroute.object.fast.reroute.object.legacy.fast.reroute.object._case;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.Bandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.CommonFastRerouteObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.FastRerouteFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.Priority;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.RsvpTeObject;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 * Class that builds {@link LegacyFastRerouteObject} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     LegacyFastRerouteObject createLegacyFastRerouteObject(int fooXyzzy, int barBaz) {
 *         return new LegacyFastRerouteObjectBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of LegacyFastRerouteObject, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see LegacyFastRerouteObject
 *
 */
@Generated("mdsal-binding-generator")
public class LegacyFastRerouteObjectBuilder {

    private Bandwidth _bandwidth;
    private AttributeFilter _excludeAny;
    private FastRerouteFlags _flags;
    private Uint8 _holdPriority;
    private Uint8 _hopLimit;
    private AttributeFilter _includeAll;
    private AttributeFilter _includeAny;
    private Uint8 _setupPriority;


    Map<Class<? extends Augmentation<LegacyFastRerouteObject>>, Augmentation<LegacyFastRerouteObject>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public LegacyFastRerouteObjectBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link CommonFastRerouteObject}.
     *
     * @param arg CommonFastRerouteObject from which the builder should be initialized
     */
    public LegacyFastRerouteObjectBuilder(CommonFastRerouteObject arg) {
        this._hopLimit = arg.getHopLimit();
        this._flags = arg.getFlags();
        this._bandwidth = arg.getBandwidth();
        this._holdPriority = arg.getHoldPriority();
        this._setupPriority = arg.getSetupPriority();
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }
    
    /**
     * Construct a new builder initialized from specified {@link RsvpTeObject}.
     *
     * @param arg RsvpTeObject from which the builder should be initialized
     */
    public LegacyFastRerouteObjectBuilder(RsvpTeObject arg) {
    }
    
    /**
     * Construct a new builder initialized from specified {@link Priority}.
     *
     * @param arg Priority from which the builder should be initialized
     */
    public LegacyFastRerouteObjectBuilder(Priority arg) {
        this._holdPriority = arg.getHoldPriority();
        this._setupPriority = arg.getSetupPriority();
    }
    
    /**
     * Construct a new builder initialized from specified {@link AttributeFilters}.
     *
     * @param arg AttributeFilters from which the builder should be initialized
     */
    public LegacyFastRerouteObjectBuilder(AttributeFilters arg) {
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link LegacyFastRerouteObject}.
     *
     * @param base LegacyFastRerouteObject from which the builder should be initialized
     */
    public LegacyFastRerouteObjectBuilder(LegacyFastRerouteObject base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._bandwidth = base.getBandwidth();
        this._excludeAny = base.getExcludeAny();
        this._flags = base.getFlags();
        this._holdPriority = base.getHoldPriority();
        this._hopLimit = base.getHopLimit();
        this._includeAll = base.getIncludeAll();
        this._includeAny = base.getIncludeAny();
        this._setupPriority = base.getSetupPriority();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link CommonFastRerouteObject}</li>
     *   <li>{@link Priority}</li>
     *   <li>{@link AttributeFilters}</li>
     *   <li>{@link RsvpTeObject}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof CommonFastRerouteObject castArg) {
            this._hopLimit = castArg.getHopLimit();
            this._flags = castArg.getFlags();
            this._bandwidth = castArg.getBandwidth();
            isValidArg = true;
        }
        if (arg instanceof Priority castArg) {
            this._holdPriority = castArg.getHoldPriority();
            this._setupPriority = castArg.getSetupPriority();
            isValidArg = true;
        }
        if (arg instanceof AttributeFilters castArg) {
            this._includeAny = castArg.getIncludeAny();
            this._excludeAny = castArg.getExcludeAny();
            this._includeAll = castArg.getIncludeAll();
            isValidArg = true;
        }
        if (arg instanceof RsvpTeObject castArg) {
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[CommonFastRerouteObject, Priority, AttributeFilters, RsvpTeObject]");
    }

    private static final class LazyEmpty {
        static final @NonNull LegacyFastRerouteObject INSTANCE = new LegacyFastRerouteObjectBuilder().build();
    
        private LazyEmpty() {
            // Hidden on purpose
        }
    }
    
    /**
     * Get empty instance of LegacyFastRerouteObject.
     *
     * @return An empty {@link LegacyFastRerouteObject}
     */
    public static @NonNull LegacyFastRerouteObject empty() {
        return LazyEmpty.INSTANCE;
    }

    /**
     * Return current value associated with the property corresponding to {@link LegacyFastRerouteObject#getBandwidth()}.
     *
     * @return current value
     */
    public Bandwidth getBandwidth() {
        return _bandwidth;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link LegacyFastRerouteObject#getExcludeAny()}.
     *
     * @return current value
     */
    public AttributeFilter getExcludeAny() {
        return _excludeAny;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link LegacyFastRerouteObject#getFlags()}.
     *
     * @return current value
     */
    public FastRerouteFlags getFlags() {
        return _flags;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link LegacyFastRerouteObject#getHoldPriority()}.
     *
     * @return current value
     */
    public Uint8 getHoldPriority() {
        return _holdPriority;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link LegacyFastRerouteObject#getHopLimit()}.
     *
     * @return current value
     */
    public Uint8 getHopLimit() {
        return _hopLimit;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link LegacyFastRerouteObject#getIncludeAll()}.
     *
     * @return current value
     */
    public AttributeFilter getIncludeAll() {
        return _includeAll;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link LegacyFastRerouteObject#getIncludeAny()}.
     *
     * @return current value
     */
    public AttributeFilter getIncludeAny() {
        return _includeAny;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link LegacyFastRerouteObject#getSetupPriority()}.
     *
     * @return current value
     */
    public Uint8 getSetupPriority() {
        return _setupPriority;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<LegacyFastRerouteObject>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link LegacyFastRerouteObject#getBandwidth()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public LegacyFastRerouteObjectBuilder setBandwidth(final Bandwidth value) {
        this._bandwidth = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link LegacyFastRerouteObject#getExcludeAny()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public LegacyFastRerouteObjectBuilder setExcludeAny(final AttributeFilter value) {
        this._excludeAny = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link LegacyFastRerouteObject#getFlags()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public LegacyFastRerouteObjectBuilder setFlags(final FastRerouteFlags value) {
        this._flags = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link LegacyFastRerouteObject#getHoldPriority()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public LegacyFastRerouteObjectBuilder setHoldPriority(final Uint8 value) {
        this._holdPriority = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link LegacyFastRerouteObject#getHopLimit()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public LegacyFastRerouteObjectBuilder setHopLimit(final Uint8 value) {
        this._hopLimit = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link LegacyFastRerouteObject#getIncludeAll()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public LegacyFastRerouteObjectBuilder setIncludeAll(final AttributeFilter value) {
        this._includeAll = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link LegacyFastRerouteObject#getIncludeAny()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public LegacyFastRerouteObjectBuilder setIncludeAny(final AttributeFilter value) {
        this._includeAny = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link LegacyFastRerouteObject#getSetupPriority()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public LegacyFastRerouteObjectBuilder setSetupPriority(final Uint8 value) {
        this._setupPriority = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public LegacyFastRerouteObjectBuilder addAugmentation(Augmentation<LegacyFastRerouteObject> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public LegacyFastRerouteObjectBuilder removeAugmentation(Class<? extends Augmentation<LegacyFastRerouteObject>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link LegacyFastRerouteObject} instance.
     *
     * @return A new {@link LegacyFastRerouteObject} instance.
     */
    public @NonNull LegacyFastRerouteObject build() {
        return new LegacyFastRerouteObjectImpl(this);
    }

    private static final class LegacyFastRerouteObjectImpl
        extends AbstractAugmentable<LegacyFastRerouteObject>
        implements LegacyFastRerouteObject {
    
        private final Bandwidth _bandwidth;
        private final AttributeFilter _excludeAny;
        private final FastRerouteFlags _flags;
        private final Uint8 _holdPriority;
        private final Uint8 _hopLimit;
        private final AttributeFilter _includeAll;
        private final AttributeFilter _includeAny;
        private final Uint8 _setupPriority;
    
        LegacyFastRerouteObjectImpl(LegacyFastRerouteObjectBuilder base) {
            super(base.augmentation);
            this._bandwidth = base.getBandwidth();
            this._excludeAny = base.getExcludeAny();
            this._flags = base.getFlags();
            this._holdPriority = base.getHoldPriority();
            this._hopLimit = base.getHopLimit();
            this._includeAll = base.getIncludeAll();
            this._includeAny = base.getIncludeAny();
            this._setupPriority = base.getSetupPriority();
        }
    
        @Override
        public Bandwidth getBandwidth() {
            return _bandwidth;
        }
        
        @Override
        public AttributeFilter getExcludeAny() {
            return _excludeAny;
        }
        
        @Override
        public FastRerouteFlags getFlags() {
            return _flags;
        }
        
        @Override
        public Uint8 getHoldPriority() {
            return _holdPriority;
        }
        
        @Override
        public Uint8 getHopLimit() {
            return _hopLimit;
        }
        
        @Override
        public AttributeFilter getIncludeAll() {
            return _includeAll;
        }
        
        @Override
        public AttributeFilter getIncludeAny() {
            return _includeAny;
        }
        
        @Override
        public Uint8 getSetupPriority() {
            return _setupPriority;
        }
    
        
        
        
        
        
        
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = LegacyFastRerouteObject.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return LegacyFastRerouteObject.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return LegacyFastRerouteObject.bindingToString(this);
        }
    }
}
