package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.flow.spec.object;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ieee754.rev130819.Float32;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.RsvpTeObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.ServiceNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TspecObject;
import org.opendaylight.yang.svc.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * FLOW_SPEC
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>rsvp</b>
 * <pre>
 * container flow-spec-object {
 *   uses rsvp-te-object;
 *   leaf service-header {
 *     type service-number;
 *   }
 *   uses tspec-object;
 *   leaf rate {
 *     type ieee754:float32;
 *   }
 *   leaf slack-term {
 *     type uint32;
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link FlowSpecObjectBuilder}.
 * @see FlowSpecObjectBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface FlowSpecObject
    extends
    ChildOf<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.FlowSpecObject>,
    Augmentable<FlowSpecObject>,
    RsvpTeObject,
    TspecObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("flow-spec-object");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.flow.spec.object.FlowSpecObject> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.flow.spec.object.FlowSpecObject.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.flow.spec.object.@NonNull FlowSpecObject obj) {
        int result = 1;
        final int prime = 31;
        result = prime * result + Objects.hashCode(obj.getRate());
        result = prime * result + Objects.hashCode(obj.getServiceHeader());
        result = prime * result + Objects.hashCode(obj.getSlackTerm());
        result = prime * result + Objects.hashCode(obj.getTspecObject());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.flow.spec.object.@NonNull FlowSpecObject thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.flow.spec.object.FlowSpecObject.class, obj);
        return other != null
            && Objects.equals(thisObj.getSlackTerm(), other.getSlackTerm())
            && Objects.equals(thisObj.getRate(), other.getRate())
            && Objects.equals(thisObj.getServiceHeader(), other.getServiceHeader())
            && Objects.equals(thisObj.getTspecObject(), other.getTspecObject())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.flow.spec.object.@NonNull FlowSpecObject obj) {
        final var helper = MoreObjects.toStringHelper("FlowSpecObject");
        CodeHelpers.appendValue(helper, "rate", obj.getRate());
        CodeHelpers.appendValue(helper, "serviceHeader", obj.getServiceHeader());
        CodeHelpers.appendValue(helper, "slackTerm", obj.getSlackTerm());
        CodeHelpers.appendValue(helper, "tspecObject", obj.getTspecObject());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return serviceHeader, or {@code null} if it is not present.
     *
     * @return {@code ServiceNumber} serviceHeader, or {@code null} if it is not present.
     *
     */
    ServiceNumber getServiceHeader();
    
    /**
     * Return serviceHeader, guaranteed to be non-null.
     *
     * @return {@code ServiceNumber} serviceHeader, guaranteed to be non-null.
     * @throws NoSuchElementException if serviceHeader is not present
     *
     */
    default @NonNull ServiceNumber requireServiceHeader() {
        return CodeHelpers.require(getServiceHeader(), "serviceheader");
    }
    
    /**
     * Return rate, or {@code null} if it is not present.
     *
     * @return {@code Float32} rate, or {@code null} if it is not present.
     *
     */
    Float32 getRate();
    
    /**
     * Return rate, guaranteed to be non-null.
     *
     * @return {@code Float32} rate, guaranteed to be non-null.
     * @throws NoSuchElementException if rate is not present
     *
     */
    default @NonNull Float32 requireRate() {
        return CodeHelpers.require(getRate(), "rate");
    }
    
    /**
     * Return slackTerm, or {@code null} if it is not present.
     *
     * @return {@code Uint32} slackTerm, or {@code null} if it is not present.
     *
     */
    Uint32 getSlackTerm();
    
    /**
     * Return slackTerm, guaranteed to be non-null.
     *
     * @return {@code Uint32} slackTerm, guaranteed to be non-null.
     * @throws NoSuchElementException if slackTerm is not present
     *
     */
    default @NonNull Uint32 requireSlackTerm() {
        return CodeHelpers.require(getSlackTerm(), "slackterm");
    }

}

