package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.flow.spec.object;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ieee754.rev130819.Float32;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.RsvpTeObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.ServiceNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.tspec.object.TspecObject;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Class that builds {@link FlowSpecObject} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     FlowSpecObject createFlowSpecObject(int fooXyzzy, int barBaz) {
 *         return new FlowSpecObjectBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of FlowSpecObject, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see FlowSpecObject
 *
 */
@Generated("mdsal-binding-generator")
public class FlowSpecObjectBuilder {

    private Float32 _rate;
    private ServiceNumber _serviceHeader;
    private Uint32 _slackTerm;
    private TspecObject _tspecObject;


    Map<Class<? extends Augmentation<FlowSpecObject>>, Augmentation<FlowSpecObject>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public FlowSpecObjectBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link RsvpTeObject}.
     *
     * @param arg RsvpTeObject from which the builder should be initialized
     */
    public FlowSpecObjectBuilder(RsvpTeObject arg) {
    }
    
    
    /**
     * Construct a new builder initialized from specified {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TspecObject}.
     *
     * @param arg org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TspecObject from which the builder should be initialized
     */
    public FlowSpecObjectBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TspecObject arg) {
        this._tspecObject = arg.getTspecObject();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link FlowSpecObject}.
     *
     * @param base FlowSpecObject from which the builder should be initialized
     */
    public FlowSpecObjectBuilder(FlowSpecObject base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._rate = base.getRate();
        this._serviceHeader = base.getServiceHeader();
        this._slackTerm = base.getSlackTerm();
        this._tspecObject = base.getTspecObject();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TspecObject}</li>
     *   <li>{@link RsvpTeObject}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TspecObject castArg) {
            this._tspecObject = castArg.getTspecObject();
            isValidArg = true;
        }
        if (arg instanceof RsvpTeObject castArg) {
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TspecObject, RsvpTeObject]");
    }

    private static final class LazyEmpty {
        static final @NonNull FlowSpecObject INSTANCE = new FlowSpecObjectBuilder().build();
    
        private LazyEmpty() {
            // Hidden on purpose
        }
    }
    
    /**
     * Get empty instance of FlowSpecObject.
     *
     * @return An empty {@link FlowSpecObject}
     */
    public static @NonNull FlowSpecObject empty() {
        return LazyEmpty.INSTANCE;
    }

    /**
     * Return current value associated with the property corresponding to {@link FlowSpecObject#getRate()}.
     *
     * @return current value
     */
    public Float32 getRate() {
        return _rate;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link FlowSpecObject#getServiceHeader()}.
     *
     * @return current value
     */
    public ServiceNumber getServiceHeader() {
        return _serviceHeader;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link FlowSpecObject#getSlackTerm()}.
     *
     * @return current value
     */
    public Uint32 getSlackTerm() {
        return _slackTerm;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link FlowSpecObject#getTspecObject()}.
     *
     * @return current value
     */
    public TspecObject getTspecObject() {
        return _tspecObject;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<FlowSpecObject>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link FlowSpecObject#getRate()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public FlowSpecObjectBuilder setRate(final Float32 value) {
        this._rate = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link FlowSpecObject#getServiceHeader()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public FlowSpecObjectBuilder setServiceHeader(final ServiceNumber value) {
        this._serviceHeader = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link FlowSpecObject#getSlackTerm()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public FlowSpecObjectBuilder setSlackTerm(final Uint32 value) {
        this._slackTerm = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link FlowSpecObject#getTspecObject()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public FlowSpecObjectBuilder setTspecObject(final TspecObject value) {
        this._tspecObject = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public FlowSpecObjectBuilder addAugmentation(Augmentation<FlowSpecObject> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public FlowSpecObjectBuilder removeAugmentation(Class<? extends Augmentation<FlowSpecObject>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link FlowSpecObject} instance.
     *
     * @return A new {@link FlowSpecObject} instance.
     */
    public @NonNull FlowSpecObject build() {
        return new FlowSpecObjectImpl(this);
    }

    private static final class FlowSpecObjectImpl
        extends AbstractAugmentable<FlowSpecObject>
        implements FlowSpecObject {
    
        private final Float32 _rate;
        private final ServiceNumber _serviceHeader;
        private final Uint32 _slackTerm;
        private final TspecObject _tspecObject;
    
        FlowSpecObjectImpl(FlowSpecObjectBuilder base) {
            super(base.augmentation);
            this._rate = base.getRate();
            this._serviceHeader = base.getServiceHeader();
            this._slackTerm = base.getSlackTerm();
            this._tspecObject = base.getTspecObject();
        }
    
        @Override
        public Float32 getRate() {
            return _rate;
        }
        
        @Override
        public ServiceNumber getServiceHeader() {
            return _serviceHeader;
        }
        
        @Override
        public Uint32 getSlackTerm() {
            return _slackTerm;
        }
        
        @Override
        public TspecObject getTspecObject() {
            return _tspecObject;
        }
    
        
        
        
        @Override
        public TspecObject nonnullTspecObject() {
            return Objects.requireNonNullElse(getTspecObject(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.tspec.object.TspecObjectBuilder.empty());
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = FlowSpecObject.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return FlowSpecObject.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return FlowSpecObject.bindingToString(this);
        }
    }
}
